/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.cache.CacheStorage;
import com.teamdev.jxbrowser.cookie.HttpCookieStorage;
import com.teamdev.jxbrowser.e;
import com.teamdev.jxbrowser.events.BrowserEventsThread;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.events.DisposeListener;
import com.teamdev.jxbrowser.events.HistoryChangeEvent;
import com.teamdev.jxbrowser.events.HistoryChangeListener;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.events.ProgressChangedEvent;
import com.teamdev.jxbrowser.events.ProgressListener;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.StatusListener;
import com.teamdev.jxbrowser.events.TitleChangedEvent;
import com.teamdev.jxbrowser.events.TitleListener;
import com.teamdev.jxbrowser.f;
import com.teamdev.jxbrowser.g;
import com.teamdev.jxbrowser.h;
import com.teamdev.jxbrowser.i;
import com.teamdev.jxbrowser.j;
import com.teamdev.jxbrowser.print.PrintListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBrowser<T>
implements Browser {
    private final Set<HistoryChangeListener> a;
    private final Set<NavigationListener> b;
    private final Set<ProgressListener> c;
    private final Set<DisposeListener> d;
    private final Set<StatusListener> e;
    private final Set<TitleListener> f;
    private final BrowserEventsThread g = new BrowserEventsThread();

    protected AbstractBrowser() {
        this.a = Collections.synchronizedSet(new HashSet());
        this.b = Collections.synchronizedSet(new HashSet());
        this.c = Collections.synchronizedSet(new HashSet());
        this.d = Collections.synchronizedSet(new HashSet());
        this.e = Collections.synchronizedSet(new HashSet());
        this.f = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    @Override
    public void addNavigationListener(NavigationListener navigationListener) {
        this.b.add(navigationListener);
    }

    @Override
    public void addProgressListener(ProgressListener progressListener) {
        this.c.add(progressListener);
    }

    @Override
    public void addStatusListener(StatusListener statusListener) {
        this.e.add(statusListener);
    }

    @Override
    public void removeNavigationListener(NavigationListener navigationListener) {
        this.b.remove(navigationListener);
    }

    @Override
    public void removeProgressListener(ProgressListener progressListener) {
        this.c.remove(progressListener);
    }

    @Override
    public void removeStatusListener(StatusListener statusListener) {
        this.e.remove(statusListener);
    }

    @Override
    public void addTitleListener(TitleListener titleListener) {
        this.f.add(titleListener);
    }

    @Override
    public void removeTitleListener(TitleListener titleListener) {
        this.f.remove(titleListener);
    }

    @Override
    public List<NavigationListener> getNavigationListeners() {
        return new ArrayList<NavigationListener>(this.b);
    }

    @Override
    public List<ProgressListener> getProgressListeners() {
        return new ArrayList<ProgressListener>(this.c);
    }

    @Override
    public List<StatusListener> getStatusListeners() {
        return new ArrayList<StatusListener>(this.e);
    }

    @Override
    public List<TitleListener> getTitleListeners() {
        return new ArrayList<TitleListener>(this.f);
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        this.d.add(disposeListener);
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        this.d.remove(disposeListener);
    }

    @Override
    public List<DisposeListener> getDisposeListeners() {
        return new ArrayList<DisposeListener>(this.d);
    }

    @Override
    public void addHistoryChangeListener(HistoryChangeListener historyChangeListener) {
        this.a.add(historyChangeListener);
    }

    @Override
    public List<HistoryChangeListener> getHistoryChangeListeners() {
        return new ArrayList<HistoryChangeListener>(this.a);
    }

    @Override
    public void removeHistoryChangeListener(HistoryChangeListener historyChangeListener) {
        this.a.remove(historyChangeListener);
    }

    @Override
    public BrowserServices getServices() {
        return BrowserServices.getInstance();
    }

    @Override
    public HttpCookieStorage getCookieStorage() {
        return BrowserServices.getInstance().getCookieStorage(this.getType());
    }

    @Override
    public CacheStorage getCacheStorage() {
        return BrowserServices.getInstance().getCacheStorage(this.getType());
    }

    @Override
    public NewWindowManager getNewWindowManager() {
        return this.getServices().getNewWindowManager();
    }

    public abstract boolean isReady();

    @Override
    public void waitReady() {
        int n2 = 450;
        while (!this.isReady() && n2-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    public abstract T getPeer();

    @Override
    public void print() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void print(PrintListener printListener) {
        throw new UnsupportedOperationException();
    }

    public void notifyListeners(ProgressChangedEvent progressChangedEvent) {
        Object object = this.getProgressListeners();
        object = object.iterator();
        while (object.hasNext()) {
            ProgressListener progressListener = (ProgressListener)object.next();
            this.g.invokeLater(new j(this, progressListener, progressChangedEvent));
        }
    }

    public void notifyListeners(StatusChangedEvent statusChangedEvent) {
        Object object = this.getStatusListeners();
        object = object.iterator();
        while (object.hasNext()) {
            StatusListener statusListener = (StatusListener)object.next();
            this.g.invokeLater(new h(this, statusListener, statusChangedEvent));
        }
    }

    public void notifyListeners(NavigationFinishedEvent navigationFinishedEvent) {
        Object object = this.getNavigationListeners();
        object = object.iterator();
        while (object.hasNext()) {
            NavigationListener navigationListener = (NavigationListener)object.next();
            this.g.invokeLater(new i(this, navigationListener, navigationFinishedEvent));
        }
    }

    public void notifyListeners(NavigationEvent navigationEvent) {
        Object object = this.getNavigationListeners();
        object = object.iterator();
        while (object.hasNext()) {
            NavigationListener navigationListener = (NavigationListener)object.next();
            this.g.invokeLater(new f(this, navigationListener, navigationEvent));
        }
    }

    public void notifyListeners(TitleChangedEvent titleChangedEvent) {
        Object object = this.getTitleListeners();
        object = object.iterator();
        while (object.hasNext()) {
            TitleListener titleListener = (TitleListener)object.next();
            this.g.invokeLater(new g(this, titleListener, titleChangedEvent));
        }
    }

    public void notifyListeners(DisposeEvent disposeEvent) {
        Iterator<DisposeListener> iterator = ((AbstractBrowser)((Object)iterator)).getDisposeListeners();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DisposeListener disposeListener = iterator.next();
            disposeListener.browserDisposed(disposeEvent);
        }
    }

    public void notifyListeners(HistoryChangeEvent historyChangeEvent) {
        Object object = this.getHistoryChangeListeners();
        object = object.iterator();
        while (object.hasNext()) {
            HistoryChangeListener historyChangeListener = (HistoryChangeListener)object.next();
            this.g.invokeLater(new e(this, historyChangeListener, historyChangeEvent));
        }
    }

    protected BrowserEventsThread getEventsThread() {
        return this.g;
    }
}

