/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cookie;

import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.UnsupportedBrowserTypeException;
import com.teamdev.jxbrowser.cookie.HttpCookie;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpCookieStorage {
    public abstract List<HttpCookie> getCookies();

    public abstract List<HttpCookie> getCookies(String var1);

    public abstract void setCookie(HttpCookie var1, String var2);

    public abstract void setCookie(List<HttpCookie> var1, String var2);

    public abstract void deleteCookie(HttpCookie var1);

    public abstract void deleteCookie(List<HttpCookie> var1);

    public static HttpCookieStorage getInstance(BrowserType browserType) {
        try {
            Class<Object> clazz = browserType;
            Properties properties = new Properties();
            clazz = clazz.getClass().getResourceAsStream("engine.properties");
            properties.load((InputStream)((Object)clazz));
            clazz = properties.getProperty("cookie.storage.class.name");
            clazz = Class.forName((String)((Object)clazz));
            clazz = clazz.asSubclass(HttpCookieStorage.class);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Cookie storage functionality is not implemented for given browser type: " + browserType);
        }
        catch (Exception exception) {
            throw new UnsupportedBrowserTypeException(browserType, "This browser type is unsupported for this platfrom");
        }
    }
}

