/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15;

import com.teamdev.jxbrowser.gecko15.ActiveWebBrowserSupport;
import com.teamdev.jxbrowser.gecko15.BrowserPreferences;
import com.teamdev.jxbrowser.gecko15.DeadWebBrowserSupport;
import com.teamdev.jxbrowser.gecko15.WebBrowser;
import com.teamdev.jxbrowser.gecko15.download.DownloadHandler;
import com.teamdev.jxbrowser.gecko15.download.DownloadHandlerProvider;
import com.teamdev.jxbrowser.gecko15.download.DownloadWatcher;
import com.teamdev.jxbrowser.gecko15.events.BrowserWindowEvent;
import com.teamdev.jxbrowser.gecko15.events.BrowserWindowListener;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuEvent;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuListener;
import com.teamdev.jxbrowser.gecko15.events.DisposeListener;
import com.teamdev.jxbrowser.gecko15.events.LocationEvent;
import com.teamdev.jxbrowser.gecko15.events.ProgressEvent;
import com.teamdev.jxbrowser.gecko15.events.RequestAdapter;
import com.teamdev.jxbrowser.gecko15.events.RequestListener;
import com.teamdev.jxbrowser.gecko15.events.SecurityEvent;
import com.teamdev.jxbrowser.gecko15.events.StateEvent;
import com.teamdev.jxbrowser.gecko15.events.StatusChangeEvent;
import com.teamdev.jxbrowser.gecko15.events.StatusChangeListener;
import com.teamdev.jxbrowser.gecko15.events.StatusEvent;
import com.teamdev.jxbrowser.gecko15.events.TitleChangeEvent;
import com.teamdev.jxbrowser.gecko15.events.TitleChangeListener;
import com.teamdev.jxbrowser.gecko15.events.impl.BrowserWindowListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.ContextMenuListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.RequestListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.StatusChangeListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.TitleChangeListeners;
import com.teamdev.jxbrowser.gecko15.popup.DefaultPopupHandler;
import com.teamdev.jxbrowser.gecko15.popup.PopupHandler;
import com.teamdev.jxbrowser.gecko15.popup.PopupHandlerProvider;
import com.teamdev.jxbrowser.gecko15.popup.PopupWatcher;
import com.teamdev.jxbrowser.gecko15.print.PrintWatcher;
import com.teamdev.jxbrowser.gecko15.prompt.PromptHandler;
import com.teamdev.jxbrowser.gecko15.prompt.PromptHandlerProvider;
import com.teamdev.jxbrowser.gecko15.prompt.PromptWatcher;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser
implements WebBrowser {
    private WebBrowser a;
    private final RequestListeners b;
    private final ContextMenuListeners c;
    private final TitleChangeListeners d;
    private final StatusChangeListeners e;
    private final BrowserWindowListeners f;
    private final b g;
    private final k h;
    private a i;

    public Browser() {
        this(false);
    }

    public Browser(boolean bl) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                Browser.this.a = new ActiveWebBrowserSupport();
            }
        });
        if (!bl) {
            this.initializeDocument();
        }
        this.c = new ContextMenuListeners();
        this.h();
        this.d = new TitleChangeListeners();
        this.g();
        this.e = new StatusChangeListeners();
        this.f();
        this.b = new RequestListeners();
        this.e();
        this.f = new BrowserWindowListeners();
        this.i();
        this.h = new k();
        PromptWatcher.getInstance().addPromptHandlerProvider(this.h);
        this.g = new b();
        PopupWatcher.getInstance().addPopupHandlerProvider(this.g);
        this.i = new a();
        DownloadWatcher.getInstance().addDownloadHandlerProvider(this.i);
        PrintWatcher.register();
        this.a();
    }

    private void a() {
        this.addDisposeListener(new DisposeListener(){

            public void disposed() {
                Browser.this.b();
                Browser.this.c();
                Browser.this.d();
                Browser.this.a = new DeadWebBrowserSupport();
            }
        });
    }

    private void b() {
        PopupWatcher.getInstance().removePopupHandlerProvider(this.g);
    }

    private void c() {
        PromptWatcher.getInstance().removePromptHandlerProvider(this.h);
    }

    private void d() {
        DownloadWatcher.getInstance().removeDownloadHandlerProvider(this.i);
    }

    private void e() {
        this.a.addRequestListener(new RequestListener(){

            public void stateChanged(StateEvent stateEvent) {
                StateEvent stateEvent2 = new StateEvent(Browser.this, stateEvent.getWebProgress(), stateEvent.getRequest(), stateEvent.getStateFlags(), stateEvent.getStatus());
                List<RequestListener> list = Browser.this.getRequestListeners();
                for (RequestListener requestListener : list) {
                    requestListener.stateChanged(stateEvent2);
                }
            }

            public void progressChanged(ProgressEvent progressEvent) {
                ProgressEvent progressEvent2 = new ProgressEvent(Browser.this, progressEvent.getWebProgress(), progressEvent.getRequest(), progressEvent.getCurSelfProgress(), progressEvent.getMaxSelfProgress(), progressEvent.getCurTotalProgress(), progressEvent.getMaxTotalProgress());
                List<RequestListener> list = Browser.this.getRequestListeners();
                for (RequestListener requestListener : list) {
                    requestListener.progressChanged(progressEvent2);
                }
            }

            public void locationChanged(LocationEvent locationEvent) {
                LocationEvent locationEvent2 = new LocationEvent(Browser.this, locationEvent.getWebProgress(), locationEvent.getRequest(), locationEvent.getLocation());
                List<RequestListener> list = Browser.this.getRequestListeners();
                for (RequestListener requestListener : list) {
                    requestListener.locationChanged(locationEvent2);
                }
            }

            public void statusChanged(StatusEvent statusEvent) {
                StatusEvent statusEvent2 = new StatusEvent(Browser.this, statusEvent.getWebProgress(), statusEvent.getRequest(), statusEvent.getStatus(), statusEvent.getMessage());
                List<RequestListener> list = Browser.this.getRequestListeners();
                for (RequestListener requestListener : list) {
                    requestListener.statusChanged(statusEvent2);
                }
            }

            public void securityChanged(SecurityEvent securityEvent) {
                SecurityEvent securityEvent2 = new SecurityEvent(Browser.this, securityEvent.getWebProgress(), securityEvent.getRequest(), securityEvent.getState());
                List<RequestListener> list = Browser.this.getRequestListeners();
                for (RequestListener requestListener : list) {
                    requestListener.securityChanged(securityEvent2);
                }
            }
        });
    }

    private void f() {
        this.a.addStatusChangeListener(new StatusChangeListener(){

            public void statusChanged(StatusChangeEvent statusChangeEvent) {
                StatusChangeEvent statusChangeEvent2 = new StatusChangeEvent(Browser.this, statusChangeEvent.getStatusType(), statusChangeEvent.getStatus());
                List<StatusChangeListener> list = Browser.this.getStatusChangeListeners();
                for (StatusChangeListener statusChangeListener : list) {
                    statusChangeListener.statusChanged(statusChangeEvent2);
                }
            }
        });
    }

    private void g() {
        this.a.addTitleChangeListener(new TitleChangeListener(){

            public void titleChanged(TitleChangeEvent titleChangeEvent) {
                TitleChangeEvent titleChangeEvent2 = new TitleChangeEvent(Browser.this, titleChangeEvent.getTitle());
                List<TitleChangeListener> list = Browser.this.getTitleChangeListeners();
                for (TitleChangeListener titleChangeListener : list) {
                    titleChangeListener.titleChanged(titleChangeEvent2);
                }
            }
        });
    }

    private void h() {
        this.a.addContextMenuListener(new ContextMenuListener(){

            public void contextMenuRequested(ContextMenuEvent contextMenuEvent) {
                ContextMenuEvent contextMenuEvent2 = new ContextMenuEvent(Browser.this, contextMenuEvent.getContextFlags(), contextMenuEvent.getMouseEvent(), contextMenuEvent.getTargetNode(), contextMenuEvent.getAssociatedLink(), contextMenuEvent.getImageSrc(), contextMenuEvent.getBackgroundImageSrc(), contextMenuEvent.getX(), contextMenuEvent.getY());
                List<ContextMenuListener> list = Browser.this.getContextMenuListeners();
                for (ContextMenuListener contextMenuListener : list) {
                    contextMenuListener.contextMenuRequested(contextMenuEvent2);
                }
            }
        });
    }

    private void i() {
        this.a.addBrowserWindowListener(new BrowserWindowListener(){

            public void windowVisible(BrowserWindowEvent browserWindowEvent) {
                BrowserWindowEvent browserWindowEvent2 = new BrowserWindowEvent((Object)Browser.this, browserWindowEvent.isVisible());
                List<BrowserWindowListener> list = Browser.this.getBrowserWindowListeners();
                for (BrowserWindowListener browserWindowListener : list) {
                    browserWindowListener.windowVisible(browserWindowEvent2);
                }
            }

            public void windowSizeChanged(BrowserWindowEvent browserWindowEvent) {
                BrowserWindowEvent browserWindowEvent2 = new BrowserWindowEvent((Object)Browser.this, new Rectangle(browserWindowEvent.getSize()));
                List<BrowserWindowListener> list = Browser.this.getBrowserWindowListeners();
                for (BrowserWindowListener browserWindowListener : list) {
                    browserWindowListener.windowSizeChanged(browserWindowEvent2);
                }
            }

            public void windowLocationChanged(BrowserWindowEvent browserWindowEvent) {
                BrowserWindowEvent browserWindowEvent2 = new BrowserWindowEvent((Object)Browser.this, new Rectangle(browserWindowEvent.getLocation()));
                List<BrowserWindowListener> list = Browser.this.getBrowserWindowListeners();
                for (BrowserWindowListener browserWindowListener : list) {
                    browserWindowListener.windowLocationChanged(browserWindowEvent2);
                }
            }
        });
    }

    public void initializeDocument() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        RequestAdapter requestAdapter = new RequestAdapter(){

            public void stateChanged(StateEvent stateEvent) {
                if (stateEvent.isLoadingCompleted()) {
                    countDownLatch.countDown();
                }
            }
        };
        this.a.addRequestListener(requestAdapter);
        this.navigate("about:blank");
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.a.removeRequestListener(requestAdapter);
    }

    @Override
    public Component getComponent() {
        return this.a.getComponent();
    }

    @Override
    public void navigate(String string) {
        this.a.navigate(string);
    }

    @Override
    public void navigate(String string, String string2) {
        this.a.navigate(string, string2);
    }

    @Override
    public void navigate(String string, String string2, long l2) {
        this.a.navigate(string, string2, l2);
    }

    @Override
    public void setContent(String string) {
        this.a.setContent(string);
    }

    @Override
    public void setContent(String string, String string2) {
        this.a.setContent(string, string2);
    }

    @Override
    public void setContent(String string, String string2, String string3) {
        this.a.setContent(string, string2, string3);
    }

    @Override
    public void setContent(String string, String string2, String string3, String string4) {
        this.a.setContent(string, string2, string3, string4);
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            this.a.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.a instanceof DeadWebBrowserSupport;
    }

    @Override
    public String getLocationURL() {
        return this.a.getLocationURL();
    }

    @Override
    public String getTitle() {
        return this.a.getTitle();
    }

    @Override
    public void goForward() {
        this.a.goForward();
    }

    @Override
    public void goBack() {
        this.a.goBack();
    }

    @Override
    public boolean canGoBack() {
        return this.a.canGoBack();
    }

    @Override
    public boolean canGoForward() {
        return this.a.canGoForward();
    }

    @Override
    public void stop() {
        this.a.stop();
    }

    @Override
    public void refresh() {
        this.a.refresh();
    }

    @Override
    public void addRequestListener(RequestListener requestListener) {
        this.b.addRequestListener(requestListener);
    }

    @Override
    public void removeRequestListener(RequestListener requestListener) {
        this.b.removeRequestListener(requestListener);
    }

    @Override
    public List<RequestListener> getRequestListeners() {
        return this.b.getRequestListeners();
    }

    @Override
    public void addStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.e.addStatusChangeListener(statusChangeListener);
    }

    @Override
    public void removeStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.e.removeStatusChangeListener(statusChangeListener);
    }

    @Override
    public List<StatusChangeListener> getStatusChangeListeners() {
        return this.e.getStatusChangeListeners();
    }

    @Override
    public void addTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.d.addTitleChangeListener(titleChangeListener);
    }

    @Override
    public void removeTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.d.removeTitleChangeListener(titleChangeListener);
    }

    @Override
    public List<TitleChangeListener> getTitleChangeListeners() {
        return this.d.getTitleChangeListeners();
    }

    @Override
    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        this.c.addContextMenuListener(contextMenuListener);
    }

    @Override
    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        this.c.removeContextMenuListener(contextMenuListener);
    }

    @Override
    public List<ContextMenuListener> getContextMenuListeners() {
        return this.c.getContextMenuListeners();
    }

    @Override
    public Document getDocument() {
        return this.a.getDocument();
    }

    @Override
    public String evaluateScript(String string) {
        return this.a.evaluateScript(string);
    }

    @Override
    public nsIWebBrowser getNsIWebBrowser() {
        return this.a.getNsIWebBrowser();
    }

    @Override
    public void setPreferences(BrowserPreferences browserPreferences) {
        this.a.setPreferences(browserPreferences);
    }

    @Override
    public BrowserPreferences getPreferences() {
        return this.a.getPreferences();
    }

    @Override
    public String getDocumentContent() {
        return this.a.getDocumentContent();
    }

    @Override
    public String getDocumentContent(String string) {
        return this.a.getDocumentContent(string);
    }

    @Override
    public BufferedImage toImage() {
        return this.a.toImage();
    }

    @Override
    public BufferedImage toImage(Dimension dimension) {
        return this.a.toImage(dimension);
    }

    @Override
    public boolean isMimeTypeSupported(String string) {
        return this.a.isMimeTypeSupported(string);
    }

    @Override
    public void addDisposeListener(DisposeListener disposeListener) {
        this.a.addDisposeListener(disposeListener);
    }

    @Override
    public void removeDisposeListener(DisposeListener disposeListener) {
        this.a.removeDisposeListener(disposeListener);
    }

    @Override
    public List<DisposeListener> getDisposeListeners() {
        return this.a.getDisposeListeners();
    }

    @Override
    public void addBrowserWindowListener(BrowserWindowListener browserWindowListener) {
        this.f.addBrowserWindowListener(browserWindowListener);
    }

    @Override
    public void removeBrowserWindowListener(BrowserWindowListener browserWindowListener) {
        this.f.removeBrowserWindowListener(browserWindowListener);
    }

    @Override
    public List<BrowserWindowListener> getBrowserWindowListeners() {
        return this.f.getBrowserWindowListeners();
    }

    @Override
    public void saveWebPage(File file, String string) {
        this.a.saveWebPage(file, string);
    }

    @Override
    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.i.a(downloadHandler);
    }

    @Override
    public DownloadHandler getDownloadHandler() {
        return this.i.a();
    }

    public void setPromptHandler(PromptHandler promptHandler) {
        this.h.a(promptHandler);
    }

    public void setPopupHandler(PopupHandler popupHandler) {
        this.g.a(popupHandler);
    }

    private class a
    implements DownloadHandlerProvider {
        private DownloadHandler b;

        private a() {
        }

        public DownloadHandler a() {
            return this.b;
        }

        public void a(DownloadHandler downloadHandler) {
            this.b = downloadHandler;
        }

        public DownloadHandler getHandler(nsIDOMWindow nsIDOMWindow2) {
            nsIDOMWindow nsIDOMWindow3 = Browser.this.getNsIWebBrowser().getContentDOMWindow();
            if (nsIDOMWindow2 != null && nsIDOMWindow2.equals(nsIDOMWindow3)) {
                return this.a();
            }
            return null;
        }
    }

    private class k
    implements PromptHandlerProvider {
        private PromptHandler b;

        private k() {
        }

        public PromptHandler a() {
            return this.b;
        }

        public void a(PromptHandler promptHandler) {
            this.b = promptHandler;
        }

        public PromptHandler getHandler(nsIDOMWindow nsIDOMWindow2) {
            nsIDOMWindow nsIDOMWindow3 = Browser.this.getNsIWebBrowser().getContentDOMWindow().getTop();
            if (nsIDOMWindow2 != null && nsIDOMWindow2.getTop().equals(nsIDOMWindow3)) {
                return this.b;
            }
            return null;
        }
    }

    private class b
    implements PopupHandlerProvider {
        private PopupHandler b = new DefaultPopupHandler();

        private b() {
        }

        public void a(PopupHandler popupHandler) {
            this.b = popupHandler;
        }

        public PopupHandler getHandler(nsIWebBrowser nsIWebBrowser2) {
            if (nsIWebBrowser2 != null && nsIWebBrowser2.equals(Browser.this.getNsIWebBrowser())) {
                return this.b;
            }
            return null;
        }
    }
}

