/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.download;

import com.teamdev.jxbrowser.gecko15.download.DownloadHandler;
import com.teamdev.jxbrowser.gecko15.download.DownloadTransaction;
import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxyManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMDocument;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDownload;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDownloadManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDownloadProgressListener;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIHelperAppLauncher;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsILocalFile;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIRequest;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebProgress;
import com.teamdev.jxbrowser.gecko15.xpcom.util.FlagUtil;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadManager {
    private static final Logger a = LoggerFactory.getLogger(DownloadManager.class);
    private final DownloadHandler b;
    private DownloadTransaction c;

    public DownloadManager(DownloadHandler downloadHandler, DownloadTransaction downloadTransaction) {
        this.b = downloadHandler;
        this.c = downloadTransaction;
    }

    public void handleDownload(nsIHelperAppLauncher nsIHelperAppLauncher2) {
        if (this.b.allowDownloadTransaction(this.c)) {
            this.c = this.a(this.b, this.c);
            this.c = this.b(this.b, this.c);
            this.a(this.b, nsIHelperAppLauncher2, this.c);
        }
    }

    private DownloadTransaction a(DownloadHandler downloadHandler, DownloadTransaction downloadTransaction) {
        String string = downloadHandler.getDownloadsDirPath(downloadTransaction);
        return new DownloadTransaction(downloadTransaction.getURL(), string, downloadTransaction.getFileName(), downloadTransaction.getMimeType());
    }

    private DownloadTransaction b(DownloadHandler downloadHandler, DownloadTransaction downloadTransaction) {
        String string = downloadHandler.getDestinationFileName(downloadTransaction);
        return new DownloadTransaction(downloadTransaction.getURL(), downloadTransaction.getDirPath(), string, downloadTransaction.getMimeType());
    }

    private void a(final DownloadHandler downloadHandler, nsIHelperAppLauncher nsIHelperAppLauncher2, final DownloadTransaction downloadTransaction) {
        String string = downloadTransaction.getDirPath();
        if (string == null || string.length() == 0) {
            a.error("Downloads dir path cannot be null or empty.");
            return;
        }
        final String string2 = downloadTransaction.getFileName();
        if (string2 == null || string2.length() == 0) {
            a.error("File name cannot be null or empty.");
            return;
        }
        final File file = new File(string);
        if (!(file.exists() || !file.mkdirs() || file.exists() && file.isDirectory())) {
            String string3 = "Cannot create required directories: " + string;
            a.error(string3);
            throw new IllegalStateException(string3);
        }
        final nsIDownloadManager nsIDownloadManager2 = XPCOM.getService("@mozilla.org/download-manager;1", nsIDownloadManager.class);
        a a2 = new a(){

            public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3, nsIDownload nsIDownload2) {
                if (FlagUtil.checkFlag(l2, 16L)) {
                    downloadHandler.downloadFinished(new DownloadTransaction(downloadTransaction.getURL(), file.getAbsolutePath(), string2, downloadTransaction.getMimeType()));
                    nsIDownloadManager2.removeListener(this);
                }
            }
        };
        nsIDownloadManager2.addListener(a2);
        nsILocalFile nsILocalFile2 = Mozilla.NewLocalFile(new File(string, string2).getAbsolutePath(), true);
        nsIHelperAppLauncher2.saveToDisk(nsILocalFile2, true);
    }

    private class a
    implements nsIDownloadProgressListener {
        private a() {
        }

        public nsIDOMDocument getDocument() {
            return null;
        }

        public void setDocument(nsIDOMDocument nsIDOMDocument2) {
        }

        public void onDownloadStateChange(short s, nsIDownload nsIDownload2) {
        }

        public void onStateChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3, nsIDownload nsIDownload2) {
        }

        public void onProgressChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, long l3, long l4, long l5, nsIDownload nsIDownload2) {
        }

        public void onSecurityChange(nsIWebProgress nsIWebProgress2, nsIRequest nsIRequest2, long l2, nsIDownload nsIDownload2) {
        }

        public nsISupports queryInterface(String string) {
            return XPCOMJavaProxyManager.queryInterface(this, string);
        }
    }
}

