/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.gecko15.events.BrowserWindowListener;
import com.teamdev.jxbrowser.gecko15.events.ContextMenuListener;
import com.teamdev.jxbrowser.gecko15.events.DisposeListener;
import com.teamdev.jxbrowser.gecko15.events.StatusChangeListener;
import com.teamdev.jxbrowser.gecko15.events.TitleChangeListener;
import com.teamdev.jxbrowser.gecko15.events.impl.BrowserWindowListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.ContextMenuListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.DisposeListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.StatusChangeListeners;
import com.teamdev.jxbrowser.gecko15.events.impl.TitleChangeListeners;
import com.teamdev.jxbrowser.gecko15.xpcom.MouseKeyboardSupport;
import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.TooltipHelper;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMJavaProxyManager;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIBaseWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIContextMenuInfo;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIContextMenuListener2;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMDocument;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMElement;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMEvent;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMEventListener;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMEventTarget;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIEmbeddingSiteWindow2;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIInterfaceRequestor;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsISupports;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsITooltipListener;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowser;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserChrome2;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserChromeFocus;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserFocus;
import com.teamdev.jxbrowser.gecko15.xpcom.linux.LinuxAWTChromeContainer;
import com.teamdev.jxbrowser.gecko15.xpcom.mac.MacAWTChromeContainer;
import com.teamdev.jxbrowser.gecko15.xpcom.windows.WindowsAWTChromeContainer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChromeContainerWindow
implements nsIContextMenuListener2,
nsIEmbeddingSiteWindow2,
nsIInterfaceRequestor,
nsITooltipListener,
nsIWebBrowserChrome2,
nsIWebBrowserChromeFocus {
    private nsIWebBrowser a;
    private boolean b;
    private MouseKeyboardSupport c;
    private final TooltipHelper d = new TooltipHelper();
    private final DisposeListeners e = new DisposeListeners();
    private final FocusListener f;
    private final TitleChangeListeners g;
    private final ContextMenuListeners h = new ContextMenuListeners();
    private final AWTEventListener i;
    private final StatusChangeListeners j;
    private final BrowserWindowListeners k;
    private final AWTEventListener l;
    private final b m;

    public static ChromeContainerWindow newContainer() {
        if (PlatformContext.isWindows()) {
            return new WindowsAWTChromeContainer();
        }
        if (PlatformContext.isLinux()) {
            return new LinuxAWTChromeContainer();
        }
        if (PlatformContext.isMacOS()) {
            return new MacAWTChromeContainer();
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public ChromeContainerWindow() {
        this.g = new TitleChangeListeners();
        this.j = new StatusChangeListeners();
        this.k = new BrowserWindowListeners();
        this.f = new a();
        this.m = new b();
        this.i = new c();
        this.l = new k();
    }

    @Override
    public void setWebBrowser(nsIWebBrowser nsIWebBrowser2) {
        this.a = nsIWebBrowser2;
        this.a.setContainerWindow(this);
        nsIBaseWindow nsIBaseWindow2 = XPCOM.queryInterface(nsIWebBrowser2, nsIBaseWindow.class);
        nsIBaseWindow2.initWindow(this.getSiteWindow(), 0L, 0, 0, 0, 0);
        nsIBaseWindow2.create();
        nsIBaseWindow2.setVisibility(true);
        Mozilla.release(nsIBaseWindow2);
        this.g();
        this.e();
        this.c();
        this.a();
        this.c = new MouseKeyboardSupport(this.a, this.getContainerComponent());
    }

    private void a() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this.i, 524288L);
    }

    private void b() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this.i);
    }

    private void c() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this.l, 4L);
    }

    private void d() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this.l);
    }

    private void e() {
        this.getContainerComponent().addFocusListener(this.f);
    }

    private void f() {
        this.getContainerComponent().removeFocusListener(this.f);
    }

    private void g() {
        nsIDOMEventTarget nsIDOMEventTarget2 = this.a.getContentDOMWindow().getWindowRoot();
        nsIDOMEventTarget2.addEventListener("mousedown", this.m, true);
    }

    private void h() {
        nsIDOMEventTarget nsIDOMEventTarget2 = this.a.getContentDOMWindow().getWindowRoot();
        nsIDOMEventTarget2.removeEventListener("mousedown", this.m, true);
    }

    @Override
    public void destroyBrowserWindow() {
        this.h();
        this.f();
        this.d();
        this.b();
        this.c.dispose(this.a);
        this.g.dispose();
        this.h.dispose();
        this.j.dispose();
        this.k.dispose();
        this.a.setParentURIContentListener(null);
        nsIBaseWindow nsIBaseWindow2 = (nsIBaseWindow)this.a.queryInterface("{7144ac8b-6702-4a4b-a73d-d1d4e9717e46}");
        nsIBaseWindow2.setVisibility(false);
        nsIBaseWindow2.destroy();
        Mozilla.release(nsIBaseWindow2);
        this.a.setContainerWindow(null);
        Mozilla.release(this.a);
        this.e.fireDisposedEvent();
        this.e.dispose();
        this.a = null;
    }

    @Override
    public nsIWebBrowser getWebBrowser() {
        return this.a;
    }

    protected boolean isDisposed() {
        return this.a == null;
    }

    @Override
    public void setStatus(long l2, String string) {
        this.setStatusWithContext(l2, string, null);
    }

    @Override
    public void setStatusWithContext(long l2, String string, nsISupports nsISupports2) {
        String string2 = string == null ? "" : string;
        this.j.fireStatusChangeEvent(l2, string2);
    }

    @Override
    public nsISupports getInterface(String string) {
        if (string.equals("{a1af6cd9-c6e7-4037-99f8-dbca1b03e345}")) {
            return this.a.getContentDOMWindow();
        }
        return this.queryInterface(string);
    }

    @Override
    public String getTitle() {
        return this.g.getTitle();
    }

    @Override
    public void setTitle(String string) {
        String string2 = string == null ? "" : string;
        this.g.setTitle(string2);
        this.g.fireTitlesChangeEvent();
    }

    @Override
    public void onShowContextMenu(long l2, nsIContextMenuInfo nsIContextMenuInfo2) {
        this.h.fireContextMenuEvent(l2, nsIContextMenuInfo2);
    }

    @Override
    public void setVisibility(boolean bl) {
        this.k.fireWindowVisible(bl);
    }

    @Override
    public boolean getVisibility() {
        return true;
    }

    @Override
    public void sizeBrowserTo(int n2, int n3) {
        this.k.fireWindowSizeChanged(new Dimension(n2, n3));
    }

    public void setDimensions(long l2, int n2, int n3, int n4, int n5) {
        if ((l2 & 1L) != 0L) {
            this.k.fireWindowLocationChanged(new Point(n2, n3));
        } else if ((l2 & 6L) != 0L) {
            this.k.fireWindowSizeChanged(new Dimension(n4, n5));
        }
    }

    public void getDimensions(long l2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
    }

    @Override
    public nsISupports queryInterface(String string) {
        return XPCOMJavaProxyManager.queryInterface(this, string);
    }

    public void dispose() {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                ChromeContainerWindow.this.destroyBrowserWindow();
            }
        });
    }

    @Override
    public void onHideTooltip() {
        this.d.hide();
    }

    @Override
    public void onShowTooltip(int n2, int n3, String string) {
        this.d.showTooltip(this.getContainerComponent(), string, n2, n3);
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void focusNextElement() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChromeContainerWindow.this.getContainerComponent().transferFocus();
            }
        });
    }

    @Override
    public void focusPrevElement() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChromeContainerWindow.this.getContainerComponent().transferFocusBackward();
            }
        });
    }

    public abstract Component getContainerComponent();

    public void addDisposeListener(DisposeListener disposeListener) {
        this.e.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.e.removeDisposeListener(disposeListener);
    }

    public List<DisposeListener> getDisposeListeners() {
        return this.e.getDisposeListeners();
    }

    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        this.h.addContextMenuListener(contextMenuListener);
    }

    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        this.h.removeContextMenuListener(contextMenuListener);
    }

    public List<ContextMenuListener> getContextMenuListeners() {
        return this.h.getContextMenuListeners();
    }

    public void addTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.g.addTitleChangeListener(titleChangeListener);
    }

    public void removeTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.g.removeTitleChangeListener(titleChangeListener);
    }

    public List<TitleChangeListener> getTitleChangeListeners() {
        return this.g.getTitleChangeListeners();
    }

    public void addStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.j.addStatusChangeListener(statusChangeListener);
    }

    public void removeStatusChangeListener(StatusChangeListener statusChangeListener) {
        this.j.removeStatusChangeListener(statusChangeListener);
    }

    public List<StatusChangeListener> getStatusChangeListeners() {
        return this.j.getStatusChangeListeners();
    }

    public void addBrowserWindowListener(BrowserWindowListener browserWindowListener) {
        this.k.addBrowserWindowListener(browserWindowListener);
    }

    public void removeBrowserWindowListener(BrowserWindowListener browserWindowListener) {
        this.k.removeBrowserWindowListener(browserWindowListener);
    }

    public List<BrowserWindowListener> getBrowserWindowListeners() {
        return this.k.getBrowserWindowListeners();
    }

    private boolean i() {
        return !this.b;
    }

    private void j() {
        this.b = false;
    }

    private void k() {
        this.b = true;
    }

    private boolean l() {
        return this.b;
    }

    private void a(final Component component) {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                if (!ChromeContainerWindow.this.isDisposed()) {
                    nsIWebBrowserFocus nsIWebBrowserFocus2 = XPCOM.queryInterface(ChromeContainerWindow.this.a, nsIWebBrowserFocus.class);
                    nsIWebBrowserFocus2.activate();
                    Mozilla.release(nsIWebBrowserFocus2);
                    ChromeContainerWindow.this.k();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                if (!ChromeContainerWindow.this.isDisposed() && !ChromeContainerWindow.this.b) {
                    component.requestFocus();
                }
            }
        });
    }

    private void m() {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                if (ChromeContainerWindow.this.i() && !ChromeContainerWindow.this.isDisposed()) {
                    nsIWebBrowserFocus nsIWebBrowserFocus2 = XPCOM.queryInterface(ChromeContainerWindow.this.a, nsIWebBrowserFocus.class);
                    nsIWebBrowserFocus2.activate();
                    nsIDOMWindow nsIDOMWindow2 = ChromeContainerWindow.this.a.getContentDOMWindow();
                    nsIWebBrowserFocus2.setFocusedWindow(nsIDOMWindow2);
                    nsIDOMDocument nsIDOMDocument2 = nsIDOMWindow2.getDocument();
                    nsIDOMElement nsIDOMElement2 = nsIDOMDocument2.getDocumentElement();
                    if (nsIDOMElement2 != null) {
                        nsIWebBrowserFocus2.setFocusedElement(nsIDOMElement2);
                    }
                    ChromeContainerWindow.this.k();
                    Mozilla.release(nsIWebBrowserFocus2);
                }
            }
        });
    }

    private void n() {
        XPCOM.invokeLater(new Runnable(){

            public void run() {
                if (ChromeContainerWindow.this.l() && !ChromeContainerWindow.this.isDisposed()) {
                    nsIWebBrowserFocus nsIWebBrowserFocus2 = XPCOM.queryInterface(ChromeContainerWindow.this.a, nsIWebBrowserFocus.class);
                    nsIWebBrowserFocus2.deactivate();
                    Mozilla.release(nsIWebBrowserFocus2);
                    ChromeContainerWindow.this.j();
                }
            }
        });
    }

    static {
        com.teamdev.jxbrowser.gecko15.xpcom.a.b();
    }

    private class c
    implements AWTEventListener {
        private c() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            boolean bl;
            WindowEvent windowEvent = (WindowEvent)aWTEvent;
            Window window = SwingUtilities.getWindowAncestor(ChromeContainerWindow.this.getContainerComponent());
            boolean bl2 = bl = windowEvent.getID() == 208;
            if (bl && windowEvent.getWindow().equals(window)) {
                ChromeContainerWindow.this.n();
            }
        }
    }

    private class k
    implements AWTEventListener {
        private k() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            FocusEvent focusEvent = (FocusEvent)aWTEvent;
            boolean bl = focusEvent.getID() == 1004;
            Component component = focusEvent.getComponent();
            if (bl && !component.equals(ChromeContainerWindow.this.getContainerComponent())) {
                ChromeContainerWindow.this.n();
            }
        }
    }

    private class a
    extends FocusAdapter {
        private a() {
        }

        public void focusGained(FocusEvent focusEvent) {
            KeyboardFocusManager keyboardFocusManager = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            Component component2 = ChromeContainerWindow.this.getContainerComponent();
            if (component != null && component.equals(component2)) {
                ChromeContainerWindow.this.m();
            }
        }
    }

    private class b
    implements nsIDOMEventListener {
        private b() {
        }

        public void handleEvent(nsIDOMEvent nsIDOMEvent2) {
            Component component = ChromeContainerWindow.this.getContainerComponent();
            this.a(component);
            ChromeContainerWindow.this.a(component);
        }

        private void a(Component component) {
            while (component != null) {
                JInternalFrame jInternalFrame;
                if (component instanceof JInternalFrame && !(jInternalFrame = (JInternalFrame)component).isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                jInternalFrame.setSelected(true);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                throw new RuntimeException(propertyVetoException);
                            }
                        }
                    });
                }
                component = component.getParent();
            }
        }

        public nsISupports queryInterface(String string) {
            return XPCOMJavaProxyManager.queryInterface(this, string);
        }
    }
}

