/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.gecko15.xpcom.DefaultProfileDirectoryProvider;
import com.teamdev.jxbrowser.gecko15.xpcom.Mozilla;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOMException;
import com.teamdev.jxbrowser.gecko15.xpcom.a;
import com.teamdev.jxbrowser.gecko15.xpcom.mac.MacMozillaToolkit;
import com.teamdev.jxbrowser.gecko15.xpcom.windows.WindowsMozillaToolkit;
import java.io.File;

public abstract class MozillaToolkit {
    public static MozillaToolkit create() {
        if (PlatformContext.isWindows()) {
            return new WindowsMozillaToolkit();
        }
        if (PlatformContext.isMacOS()) {
            return new MacMozillaToolkit();
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    protected MozillaToolkit() {
    }

    protected abstract void initEnvironment();

    protected abstract String getXPCOMNativeLibraryName();

    public void initialize() {
        this.initEnvironment();
        this.a();
        if (!Mozilla.InitializeJavaGlobals()) {
            throw new XPCOMException("Cannot initialize Java globals.");
        }
        String string = System.getProperty("GRE_HOME");
        String string2 = string + File.separator + this.getXPCOMNativeLibraryName();
        long l2 = Mozilla.XPCOMGlueStartup(string2);
        if (l2 != 0L) {
            throw new XPCOMException(l2);
        }
        l2 = Mozilla.XPCOMGlueLoadXULFunctions();
        if (l2 != 0L) {
            throw new XPCOMException(l2);
        }
        l2 = Mozilla.InitEmbedding(string, new DefaultProfileDirectoryProvider(this.createProfileDir()));
        if (l2 != 0L) {
            throw new XPCOMException(l2);
        }
        l2 = Mozilla.NotifyProfile();
        if (l2 != 0L) {
            throw new XPCOMException(l2);
        }
    }

    private void a() {
        if (Boolean.valueOf(System.getProperty("jxbrowser.run.applets")).booleanValue()) {
            String string = System.getProperty("java.home");
            String string2 = string + File.separator + "bin" + File.separator + "new_plugin";
            String string3 = System.getProperty("jxbrowser.plugin.dir") != null ? System.getProperty("jxbrowser.plugin.dir") + File.pathSeparator + string2 : string2;
            System.setProperty("jxbrowser.plugin.dir", string3);
            String string4 = string + File.separator + "lib" + File.separator + "javaws.jar" + File.pathSeparator;
            string4 = string4 + string + File.separator + "lib" + File.separator + "deploy.jar" + File.pathSeparator;
            string4 = string4 + string + File.separator + "lib" + File.separator + "plugin.jar" + File.pathSeparator;
            System.setProperty("sun.boot.class.path", string4 + System.getProperty("sun.boot.class.path"));
        }
    }

    public File createProfileDir() {
        File file = new File(System.getProperty("java.io.tmpdir"), "jxbrowser-profile");
        boolean bl = Boolean.valueOf(System.getProperty("jxbrowser.xulrunner.use.profile", "true"));
        boolean bl2 = System.getProperties().containsKey("jxbrowser.home.dir");
        if (bl && bl2) {
            String string = System.getProperty("jxbrowser.home.dir");
            String string2 = System.getProperty("jxbrowser.xulrunner.version");
            String string3 = "xulrunner-profile-" + string2;
            String string4 = new File(new File(string), string3).getAbsolutePath();
            file = new File(System.getProperty("jxbrowser.xulrunner.profile.dir", string4));
            if (!file.exists() && !file.mkdirs()) {
                throw new RuntimeException("Cannot create profile directory: " + file);
            }
        }
        System.setProperty("jxbrowser.xulrunner.profile.dir", file.getAbsolutePath());
        return file;
    }

    static {
        a.b().a();
    }
}

