/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.gecko15.xpcom.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class XULRunnerZIPExtractor {
    public void extract(File file, String string) {
        this.a(file);
        this.a(string);
        this.b(file);
        File file2 = new File(file, string);
        try {
            this.a(string, file2);
            this.a(file, file2);
        }
        catch (ZipException zipException) {
            throw new RuntimeException(zipException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (!file2.delete()) {
                file2.deleteOnExit();
            }
        }
    }

    private void a(File file, File file2) throws IOException {
        ZipFile zipFile = new ZipFile(file2);
        this.a(zipFile, file);
        zipFile.close();
    }

    private void a(File file) {
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Cannot create directory to extract XULRunner. File with the same name already exists: " + file.getAbsolutePath());
        }
    }

    private void a(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot find file: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, File file) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (!file.createNewFile()) {
            throw new RuntimeException("Cannot create file: " + file.getAbsolutePath());
        }
        FileChannel fileChannel = new FileOutputStream(file).getChannel();
        try {
            this.a(inputStream, fileChannel);
        }
        finally {
            inputStream.close();
            fileChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ZipFile zipFile, File file) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            File file2 = new File(file, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                this.b(file2);
                continue;
            }
            FileChannel fileChannel = new FileOutputStream(file2).getChannel();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                try {
                    this.a(inputStream, fileChannel);
                }
                finally {
                    inputStream.close();
                    fileChannel.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private void b(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Cannot create directory: " + file.getPath());
        }
    }

    private void a(InputStream inputStream, FileChannel fileChannel) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        fileChannel.transferFrom(readableByteChannel, 0L, inputStream.available());
    }
}

