/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla15.print;

import com.jniwrapper.PlatformContext;
import com.teamdev.jxbrowser.gecko15.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIDOMWindow;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIInterfaceRequestor;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIPrintSettings;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIPrintSettingsService;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowser;
import com.teamdev.jxbrowser.gecko15.xpcom.interfaces.nsIWebBrowserPrint;
import com.teamdev.jxbrowser.mozilla15.print.MozillaPrintingLinux;
import com.teamdev.jxbrowser.mozilla15.print.MozillaPrintingMac;
import com.teamdev.jxbrowser.mozilla15.print.MozillaPrintingWindows;
import com.teamdev.jxbrowser.mozilla15.print.PrintProgressListener;
import com.teamdev.jxbrowser.print.PrintListener;

public abstract class MozillaPrinting {
    public static MozillaPrinting create() {
        if (PlatformContext.isWindows()) {
            return new MozillaPrintingWindows();
        }
        if (PlatformContext.isMacOS()) {
            return new MozillaPrintingMac();
        }
        if (PlatformContext.isLinux()) {
            return new MozillaPrintingLinux();
        }
        return null;
    }

    public void print(final PrintListener printListener, final nsIWebBrowser nsIWebBrowser2) {
        XPCOM.invokeAndWait(new Runnable(){

            public void run() {
                MozillaPrinting.this.a(printListener, nsIWebBrowser2);
            }
        });
    }

    private void a(PrintListener printListener, nsIWebBrowser nsIWebBrowser2) {
        PrintProgressListener printProgressListener = new PrintProgressListener(printListener);
        nsIPrintSettings nsIPrintSettings2 = this.configurePrintSettings(this.getGlobalPrintSettings());
        nsIWebBrowserPrint nsIWebBrowserPrint2 = this.a(nsIWebBrowser2);
        printProgressListener.firePrintStartedEvent();
        try {
            nsIWebBrowserPrint2.print(nsIPrintSettings2, printProgressListener);
        }
        catch (Exception exception) {
            if (this.a(exception.getMessage())) {
                printProgressListener.firePrintCanceledEvent();
            }
            throw new RuntimeException(exception);
        }
    }

    protected abstract nsIPrintSettings configurePrintSettings(nsIPrintSettings var1);

    private nsIWebBrowserPrint a(nsIWebBrowser nsIWebBrowser2) {
        nsIDOMWindow nsIDOMWindow2 = nsIWebBrowser2.getContentDOMWindow();
        nsIInterfaceRequestor nsIInterfaceRequestor2 = XPCOM.queryInterface(nsIDOMWindow2, nsIInterfaceRequestor.class);
        return (nsIWebBrowserPrint)nsIInterfaceRequestor2.getInterface("{9a7ca4b0-fbba-11d4-a869-00105a183419}");
    }

    private boolean a(String string) {
        String string2 = String.valueOf(0x80004004L);
        return string.contains(string2);
    }

    protected nsIPrintSettings getGlobalPrintSettings() {
        nsIPrintSettingsService nsIPrintSettingsService2 = this.getPrintSettingsService();
        return nsIPrintSettingsService2.getGlobalPrintSettings();
    }

    protected nsIPrintSettingsService getPrintSettingsService() {
        return XPCOM.getService("@mozilla.org/gfx/printsettings-service;1", nsIPrintSettingsService.class);
    }
}

