/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.SID;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

public class ACE {
    public static final int FILE_READ_DATA = 1;
    public static final int FILE_WRITE_DATA = 2;
    public static final int FILE_APPEND_DATA = 4;
    public static final int FILE_READ_EA = 8;
    public static final int FILE_WRITE_EA = 16;
    public static final int FILE_EXECUTE = 32;
    public static final int FILE_DELETE = 64;
    public static final int FILE_READ_ATTRIBUTES = 128;
    public static final int FILE_WRITE_ATTRIBUTES = 256;
    public static final int DELETE = 65536;
    public static final int READ_CONTROL = 131072;
    public static final int WRITE_DAC = 262144;
    public static final int WRITE_OWNER = 524288;
    public static final int SYNCHRONIZE = 0x100000;
    public static final int GENERIC_ALL = 0x10000000;
    public static final int GENERIC_EXECUTE = 0x20000000;
    public static final int GENERIC_WRITE = 0x40000000;
    public static final int GENERIC_READ = Integer.MIN_VALUE;
    boolean allow;
    int flags;
    int access;
    SID sid;

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isInherited() {
        return (this.flags & 0x10) != 0;
    }

    public int getAccessMask() {
        return this.access;
    }

    public SID getSID() {
        return this.sid;
    }

    int decode(byte[] buf, int bi) {
        this.allow = buf[bi++] == 0;
        this.flags = buf[bi++] & 0xFF;
        int size = ServerMessageBlock.readInt2(buf, bi);
        this.access = ServerMessageBlock.readInt4(buf, bi += 2);
        this.sid = new SID(buf, bi += 4);
        return size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isInherited() ? "inherited " : "direct    ");
        sb.append(this.isAllow() ? "allow " : "deny  ");
        sb.append("0x").append(Hexdump.toHexString(this.access, 8));
        sb.append(" ").append(this.sid.toString());
        return sb.toString();
    }
}

