/************************************************************************
* ļ:Driver.cpp                                                 
*     :ŷ
* :2007-11-1
*************************************************************************/

#include "Driver.h"

/************************************************************************
* :DriverEntry
* :ʼ򣬶λӲԴں˶
* б:
      pDriverObject:I/Oд
      pRegistryPath:עе·
*  ֵ:سʼ״̬
*************************************************************************/
#pragma INITCODE
extern "C" NTSTATUS DriverEntry (
			IN PDRIVER_OBJECT pDriverObject,
			IN PUNICODE_STRING pRegistryPath	) 
{
	NTSTATUS status;
	KdPrint(("DriverA:Enter A DriverEntry\n"));

	//עú
	pDriverObject->DriverUnload = HelloDDKUnload;
	pDriverObject->MajorFunction[IRP_MJ_CREATE] = HelloDDKCreate;
	pDriverObject->MajorFunction[IRP_MJ_CLOSE] = HelloDDKClose;
	pDriverObject->MajorFunction[IRP_MJ_WRITE] = HelloDDKDispatchRoutine;
	pDriverObject->MajorFunction[IRP_MJ_READ] = HelloDDKRead;
	
	//豸
	status = CreateDevice(pDriverObject);

	KdPrint(("DriverA:Leave A DriverEntry\n"));
	return status;
}

#pragma LOCKEDCODE
VOID OnTimerDpc( IN PKDPC pDpc,
					  IN PVOID pContext,
					  IN PVOID SysArg1,
					  IN PVOID SysArg2 ) 
{
	PDEVICE_OBJECT pDevObj = (PDEVICE_OBJECT)pContext;
	PDEVICE_EXTENSION pdx = (PDEVICE_EXTENSION)pDevObj->DeviceExtension;

	PIRP currentPendingIRP = pdx->currentPendingIRP;

	KdPrint(("DriverA:complete the Driver A IRP_MJ_READ irp!\n"));

	//״̬ΪSTATUS_SUCCESS
 	currentPendingIRP->IoStatus.Status = STATUS_SUCCESS;
 	currentPendingIRP->IoStatus.Information = 0;	// bytes xfered
 	IoCompleteRequest( currentPendingIRP, IO_NO_INCREMENT );
}

/************************************************************************
* :CreateDevice
* :ʼ豸
* б:
      pDriverObject:I/Oд
*  ֵ:سʼ״̬
*************************************************************************/
#pragma INITCODE
NTSTATUS CreateDevice (
		IN PDRIVER_OBJECT	pDriverObject) 
{
	NTSTATUS status;
	PDEVICE_OBJECT pDevObj;
	PDEVICE_EXTENSION pDevExt;
	
	//豸
	UNICODE_STRING devName;
	RtlInitUnicodeString(&devName,L"\\Device\\MyDDKDeviceA");
	
	//豸
	status = IoCreateDevice( pDriverObject,
						sizeof(DEVICE_EXTENSION),
						&(UNICODE_STRING)devName,
						FILE_DEVICE_UNKNOWN,
						0, TRUE,
						&pDevObj );
	if (!NT_SUCCESS(status))
		return status;

	pDevObj->Flags |= DO_BUFFERED_IO;
	pDevExt = (PDEVICE_EXTENSION)pDevObj->DeviceExtension;
	pDevExt->pDevice = pDevObj;
	pDevExt->ustrDeviceName = devName;

	KeInitializeTimer( &pDevExt->pollingTimer );

	KeInitializeDpc( &pDevExt->pollingDPC,
						OnTimerDpc,
						(PVOID) pDevObj );

	//
	UNICODE_STRING symLinkName;
	RtlInitUnicodeString(&symLinkName,L"\\??\\HelloDDKA");
	pDevExt->ustrSymLinkName = symLinkName;
	status = IoCreateSymbolicLink( &symLinkName,&devName );
	if (!NT_SUCCESS(status)) 
	{
		IoDeleteDevice( pDevObj );
		return status;
	}
	return STATUS_SUCCESS;
}

/************************************************************************
* :HelloDDKUnload
* :жز
* б:
      pDriverObject:
*  ֵ:״̬
*************************************************************************/
#pragma PAGEDCODE
VOID HelloDDKUnload (IN PDRIVER_OBJECT pDriverObject) 
{
	PDEVICE_OBJECT	pNextObj;
	KdPrint(("DriverA:Enter A DriverUnload\n"));
	pNextObj = pDriverObject->DeviceObject;
	while (pNextObj != NULL) 
	{
		PDEVICE_EXTENSION pDevExt = (PDEVICE_EXTENSION)
			pNextObj->DeviceExtension;

		//ɾ
		UNICODE_STRING pLinkName = pDevExt->ustrSymLinkName;
		IoDeleteSymbolicLink(&pLinkName);
		pNextObj = pNextObj->NextDevice;
		IoDeleteDevice( pDevExt->pDevice );
	}
	KdPrint(("DriverA:Leave A DriverUnload\n"));
}


/************************************************************************
* :HelloDDKRead
* :ԶIRPд
* б:
      pDevObj:豸
      pIrp:IO
*  ֵ:״̬
*************************************************************************/
#pragma PAGEDCODE
NTSTATUS HelloDDKRead(IN PDEVICE_OBJECT pDevObj,
								 IN PIRP pIrp) 
{
	KdPrint(("DriverA:Enter A HelloDDKRead\n"));

	PDEVICE_EXTENSION pDevExt = (PDEVICE_EXTENSION)
			pDevObj->DeviceExtension;

	//IRPΪ
	IoMarkIrpPending(pIrp);

	//IRP¼
	pDevExt->currentPendingIRP = pIrp;

	//3IRP_MJ_READIRP
	ULONG ulMicroSecond = 3000000;

	//32λת64λ
	LARGE_INTEGER timeout = RtlConvertLongToLargeInteger(-10*ulMicroSecond);
	
	KeSetTimer(
		&pDevExt->pollingTimer,
		timeout,
		&pDevExt->pollingDPC );

	KdPrint(("DriverA:Leave A HelloDDKRead\n"));

	//pending״̬
	return STATUS_PENDING;
}


/************************************************************************
* :HelloDDKDispatchRoutine
* :ԶIRPд
* б:
      pDevObj:豸
      pIrp:IO
*  ֵ:״̬
*************************************************************************/
#pragma PAGEDCODE
NTSTATUS HelloDDKDispatchRoutine(IN PDEVICE_OBJECT pDevObj,
								 IN PIRP pIrp) 
{
	KdPrint(("DriverA:Enter A HelloDDKDispatchRoutine\n"));
	NTSTATUS status = STATUS_SUCCESS;
	// IRP
	pIrp->IoStatus.Status = status;
	pIrp->IoStatus.Information = 0;	// bytes xfered
	IoCompleteRequest( pIrp, IO_NO_INCREMENT );
	KdPrint(("DriverA:Leave A HelloDDKDispatchRoutine\n"));
	return status;
}

#pragma PAGEDCODE
NTSTATUS HelloDDKCreate(IN PDEVICE_OBJECT pDevObj,
								 IN PIRP pIrp) 
{
	KdPrint(("DriverA:Enter A HelloDDKCreate\n"));
	NTSTATUS status = STATUS_SUCCESS;
	// IRP
	pIrp->IoStatus.Status = status;
	pIrp->IoStatus.Information = 0;	// bytes xfered
	IoCompleteRequest( pIrp, IO_NO_INCREMENT );
	KdPrint(("DriverA:Leave A HelloDDKCreate\n"));
	return status;
}

#pragma PAGEDCODE
NTSTATUS HelloDDKClose(IN PDEVICE_OBJECT pDevObj,
								 IN PIRP pIrp) 
{
	KdPrint(("DriverA:Enter A HelloDDKClose\n"));
	NTSTATUS status = STATUS_SUCCESS;
	// IRP
	pIrp->IoStatus.Status = status;
	pIrp->IoStatus.Information = 0;	// bytes xfered
	IoCompleteRequest( pIrp, IO_NO_INCREMENT );
	KdPrint(("DriverA:Leave A HelloDDKClose\n"));
	return status;
}