/************************************************************************
* ļ:Driver.cpp                                                 
*     :ŷ
* :2007-11-1
*************************************************************************/

#include "Driver.h"

/************************************************************************
* :DriverEntry
* :ʼ򣬶λӲԴں˶
* б:
      pDriverObject:I/Oд
      pRegistryPath:עе·
*  ֵ:سʼ״̬
*************************************************************************/
#pragma INITCODE
extern "C" NTSTATUS DriverEntry (
			IN PDRIVER_OBJECT pDriverObject,
			IN PUNICODE_STRING pRegistryPath	) 
{
	NTSTATUS status;
	KdPrint(("Enter DriverEntry\n"));

	//жغ
	pDriverObject->DriverUnload = HelloDDKUnload;

	//ǲ
	for (int i = 0; i < arraysize(pDriverObject->MajorFunction); ++i)
		pDriverObject->MajorFunction[i] = HelloDDKDispatchRoutin;

	pDriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL] = HelloDDKDeviceIOControl;
	
	//豸
	status = CreateDevice(pDriverObject);

	KdPrint(("Leave DriverEntry\n"));
	return status;
}

/************************************************************************
* :CreateDevice
* :ʼ豸
* б:
      pDriverObject:I/Oд
*  ֵ:سʼ״̬
*************************************************************************/
#pragma INITCODE
NTSTATUS CreateDevice (
		IN PDRIVER_OBJECT	pDriverObject) 
{
	NTSTATUS status;
	PDEVICE_OBJECT pDevObj;
	PDEVICE_EXTENSION pDevExt;
	
	//豸
	UNICODE_STRING devName;
	RtlInitUnicodeString(&devName,L"\\Device\\MyDDKDevice");
	
	//豸
	status = IoCreateDevice( pDriverObject,
						sizeof(DEVICE_EXTENSION),
						&(UNICODE_STRING)devName,
						FILE_DEVICE_UNKNOWN,
						0, TRUE,
						&pDevObj );
	if (!NT_SUCCESS(status))
		return status;

	pDevObj->Flags |= DO_DIRECT_IO;
	pDevExt = (PDEVICE_EXTENSION)pDevObj->DeviceExtension;
	pDevExt->pDevice = pDevObj;
	pDevExt->ustrDeviceName = devName;

	//ģļĻ
	pDevExt->buffer = (PUCHAR)ExAllocatePool(PagedPool,MAX_FILE_LENGTH);
	//ģļС
	pDevExt->file_length = 0;

	//
	UNICODE_STRING symLinkName;
	RtlInitUnicodeString(&symLinkName,L"\\??\\HelloDDK");
	pDevExt->ustrSymLinkName = symLinkName;
	status = IoCreateSymbolicLink( &symLinkName,&devName );
	if (!NT_SUCCESS(status)) 
	{
		IoDeleteDevice( pDevObj );
		return status;
	}
	return STATUS_SUCCESS;
}

/************************************************************************
* :HelloDDKUnload
* :жز
* б:
      pDriverObject:
*  ֵ:״̬
*************************************************************************/
#pragma PAGEDCODE
VOID HelloDDKUnload (IN PDRIVER_OBJECT pDriverObject) 
{
	PDEVICE_OBJECT	pNextObj;
	KdPrint(("Enter DriverUnload\n"));
	pNextObj = pDriverObject->DeviceObject;
	while (pNextObj != NULL) 
	{
		PDEVICE_EXTENSION pDevExt = (PDEVICE_EXTENSION)
			pNextObj->DeviceExtension;
		if (pDevExt->buffer)
		{
			ExFreePool(pDevExt->buffer);
			pDevExt->buffer = NULL;
		}

		//ɾ
		UNICODE_STRING pLinkName = pDevExt->ustrSymLinkName;
		IoDeleteSymbolicLink(&pLinkName);
		pNextObj = pNextObj->NextDevice;
		IoDeleteDevice( pDevExt->pDevice );
	}
}

/************************************************************************
* :HelloDDKDispatchRoutin
* :ԶIRPд
* б:
      pDevObj:豸
      pIrp:IO
*  ֵ:״̬
*************************************************************************/
#pragma PAGEDCODE
NTSTATUS HelloDDKDispatchRoutin(IN PDEVICE_OBJECT pDevObj,
								 IN PIRP pIrp) 
{
	KdPrint(("Enter HelloDDKDispatchRoutin\n"));

	PIO_STACK_LOCATION stack = IoGetCurrentIrpStackLocation(pIrp);
	//һַIRPͶӦ
	static char* irpname[] = 
	{
		"IRP_MJ_CREATE",
		"IRP_MJ_CREATE_NAMED_PIPE",
		"IRP_MJ_CLOSE",
		"IRP_MJ_READ",
		"IRP_MJ_WRITE",
		"IRP_MJ_QUERY_INFORMATION",
		"IRP_MJ_SET_INFORMATION",
		"IRP_MJ_QUERY_EA",
		"IRP_MJ_SET_EA",
		"IRP_MJ_FLUSH_BUFFERS",
		"IRP_MJ_QUERY_VOLUME_INFORMATION",
		"IRP_MJ_SET_VOLUME_INFORMATION",
		"IRP_MJ_DIRECTORY_CONTROL",
		"IRP_MJ_FILE_SYSTEM_CONTROL",
		"IRP_MJ_DEVICE_CONTROL",
		"IRP_MJ_INTERNAL_DEVICE_CONTROL",
		"IRP_MJ_SHUTDOWN",
		"IRP_MJ_LOCK_CONTROL",
		"IRP_MJ_CLEANUP",
		"IRP_MJ_CREATE_MAILSLOT",
		"IRP_MJ_QUERY_SECURITY",
		"IRP_MJ_SET_SECURITY",
		"IRP_MJ_POWER",
		"IRP_MJ_SYSTEM_CONTROL",
		"IRP_MJ_DEVICE_CHANGE",
		"IRP_MJ_QUERY_QUOTA",
		"IRP_MJ_SET_QUOTA",
		"IRP_MJ_PNP",
	};

	UCHAR type = stack->MajorFunction;
	if (type >= arraysize(irpname))
		KdPrint((" - Unknown IRP, major type %X\n", type));
	else
		KdPrint(("\t%s\n", irpname[type]));

	NTSTATUS status = STATUS_SUCCESS;
	// IRP
	pIrp->IoStatus.Status = status;
	pIrp->IoStatus.Information = 0;	// bytes xfered
	IoCompleteRequest( pIrp, IO_NO_INCREMENT );

	KdPrint(("Leave HelloDDKDispatchRoutin\n"));

	return status;
}

#define PDI_BUS_MAX     0xFF
#define PDI_DEVICE_MAX     0x1F
#define PDI_FUNCTION_MAX     0x7
#pragma PAGEDCODE
VOID EnumeratePCI()
{
	ULONG bus;
	ULONG dev;
	ULONG func;

	PCI_COMMON_CONFIG PciConfig;
	PCI_SLOT_NUMBER SlotNumber;

	KdPrint(("Bus\tDevice\tFunc\tVendor\tDevice\tBaseCls\tSubCls\tIRQ\tPIN\n"));

	for(bus = 0; bus <= PDI_BUS_MAX; ++bus)	
	{
		for(dev = 0; dev <= PDI_DEVICE_MAX; ++dev)	
		{
			for(func = 0; func <= PDI_FUNCTION_MAX; ++func)	
			{
				SlotNumber.u.AsULONG = 0;
				SlotNumber.u.bits.DeviceNumber = dev;
				SlotNumber.u.bits.FunctionNumber = func;

				RtlZeroMemory(&PciConfig,
							  sizeof(PCI_COMMON_CONFIG));
				ULONG Size = HalGetBusData(PCIConfiguration,
									 bus,
									 SlotNumber.u.AsULONG,
									 &PciConfig,
									 PCI_COMMON_HDR_LENGTH);
				if (Size==PCI_COMMON_HDR_LENGTH)
				{
					KdPrint(("%02X\t%02X\t%x\t%x\t%x\t%02X\t%02X\t%d\t%d\n",
						bus,
						dev,
						func,
						PciConfig.VendorID,
						PciConfig.DeviceID,
						PciConfig.BaseClass,
						PciConfig.SubClass,
						PciConfig.u.type0.InterruptLine,
						PciConfig.u.type0.InterruptPin));
				}
	
			}
		}
	}

}

#pragma PAGEDCODE
NTSTATUS HelloDDKDeviceIOControl(IN PDEVICE_OBJECT pDevObj,
								 IN PIRP pIrp)
{
	NTSTATUS status = STATUS_SUCCESS;
	KdPrint(("Enter HelloDDKDeviceIOControl\n"));

	//õǰջ
	PIO_STACK_LOCATION stack = IoGetCurrentIrpStackLocation(pIrp);
	//õ뻺С
	ULONG cbin = stack->Parameters.DeviceIoControl.InputBufferLength;
	//õС
	ULONG cbout = stack->Parameters.DeviceIoControl.OutputBufferLength;
	//õIOCTL
	ULONG code = stack->Parameters.DeviceIoControl.IoControlCode;

	ULONG info = 0;

	switch (code)
	{						// process request
		case READ_PORT:
		{
			KdPrint(("READ_PORT\n"));
			//ʽIOCTL
			//ʾ뻺
 			PULONG InputBuffer = (PULONG)pIrp->AssociatedIrp.SystemBuffer;
			ULONG port = (ULONG)(*InputBuffer);
			InputBuffer++;
			UCHAR method = (UCHAR)(*InputBuffer);

			KdPrint(("port:%x\n",port));
			KdPrint(("method:%x\n",method));
			//
			PULONG OutputBuffer = (PULONG)pIrp->AssociatedIrp.SystemBuffer;

			if (method==1)//8λ
			{
				*OutputBuffer = READ_PORT_UCHAR((PUCHAR)port);
			}else if(method==2)//16λ
			{
				*OutputBuffer = READ_PORT_USHORT((PUSHORT)port);
			}else if(method==4)//32λ
			{
				*OutputBuffer = READ_PORT_ULONG((PULONG)port);
			}

			//ʵʲ
 			info = 4;

			break;
		}
		case WRITE_PORT:
		{
			KdPrint(("WRITE_PORT\n"));
			//ʽIOCTL
			//ʾ뻺
 			PULONG InputBuffer = (PULONG)pIrp->AssociatedIrp.SystemBuffer;
			ULONG port = (ULONG)(*InputBuffer);
			InputBuffer++;
			UCHAR method = (UCHAR)(*InputBuffer);
			InputBuffer++;
			ULONG value = (ULONG)(*InputBuffer);

			KdPrint(("port:%x\n",port));
			KdPrint(("method:%x\n",method));
			KdPrint(("value:%x\n",value));

			//
			PULONG OutputBuffer = (PULONG)pIrp->AssociatedIrp.SystemBuffer;

			if (method==1)//8λ
			{
				WRITE_PORT_UCHAR((PUCHAR)port,(UCHAR)value);
			}else if(method==2)//16λ
			{
				WRITE_PORT_USHORT((PUSHORT)port,(USHORT)value);
			}else if(method==4)//32λ
			{
				WRITE_PORT_ULONG((PULONG)port,(ULONG)value);
			}

			//ʵʲ
 			info = 0;
			break;
		}
		case ENUM_PCI:
		{
			EnumeratePCI();
			break;
		}
		default:
			status = STATUS_INVALID_VARIANT;
	}

	// IRP
	pIrp->IoStatus.Status = status;
	pIrp->IoStatus.Information = info;	// bytes xfered
	IoCompleteRequest( pIrp, IO_NO_INCREMENT );

	KdPrint(("Leave HelloDDKDeviceIOControl\n"));

	return status;
}