// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public 
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#endif

#include "AddFileThread.h"                  // Needed for Module's Prototype(s) - audited 4 Nov 2004

#include "KnownFile.h"                      // Needed for CKnownFile - audited 4 Nov 2004
#include "opcodes.h"                        // Needed for ID_XMULEDLG - audited 4 Nov 2004
#include "otherfunctions.h"                 // Needed for nstrdup - audited 4 Nov 2004
#include "xmule.h"                          // Needed for theApp - audited 4 Nov 2004
#include "xmuleDlg.h"                       // Needed for theApp.xmuledlg - audited 4 Nov 2004

#include <iostream>                         // std::cout
#include <utility>                          // std::pair
#include <wx/event.h>                       // Needed for wxCommandEvent

using std::cout;
using std::endl;

struct UnknownFile_Struct
{
    wxString name;
    wxString directory;
    CPartFile *owner;
};

wxMutex CAddFileThread::m_lockWaitingForHashList;

wxCondition CAddFileThread::m_runWaitingForHashList(m_lockWaitingForHashList);

CTypedPtrList < CPtrList, UnknownFile_Struct *> CAddFileThread::m_sWaitingForHashList;

volatile int CAddFileThread::m_endWaitingForHashList;

CAddFileThread::CAddFileThread(): wxThread(wxTHREAD_DETACHED)
{
}

void CAddFileThread::Setup()
{
    CAddFileThread *th = new CAddFileThread();
    th->Create();
    th->Run();
}

void CAddFileThread::Shutdown()
{
    m_lockWaitingForHashList.Lock();
#if defined(__DEBUG__)
    cout << "Signaling hashing thread to terminate" << endl;
#endif
    // Tell the thread to exit
    m_endWaitingForHashList = 1;
    // Signal the thread there is something to do
    m_runWaitingForHashList.Signal();
    m_lockWaitingForHashList.Unlock();
}

void CAddFileThread::AddFile(wxString path, wxString name, CPartFile *part)
{
    UnknownFile_Struct *hashfile = new UnknownFile_Struct;
    hashfile->directory = path;
    hashfile->name = name;
    hashfile->owner = part;
    wxMutexLocker sLock(m_lockWaitingForHashList);
    m_sWaitingForHashList.AddTail(hashfile);
    m_runWaitingForHashList.Signal();
}

wxThread::ExitCode CAddFileThread::Entry()
{
    while (1)
    {
        m_lockWaitingForHashList.Lock();

        if (m_endWaitingForHashList)
        {
            m_lockWaitingForHashList.Unlock();
            wxCommandEvent evt(wxEVT_COMMAND_MENU_SELECTED, TM_HASHTHREADFINISHED);
            wxPostEvent(wxWindow::FindWindowById(ID_XMULEDLG), evt);
            return 0;
        }

        if (m_sWaitingForHashList.IsEmpty())
        {
            m_runWaitingForHashList.Wait();
            m_lockWaitingForHashList.Unlock();
            continue;
        }

        UnknownFile_Struct *hashfile = m_sWaitingForHashList.RemoveHead();
        m_lockWaitingForHashList.Unlock();
        CKnownFile *newrecord = new CKnownFile();
        
        cout << "Sharing " << hashfile->directory.mb_str(*wxConvCurrent) << "/" << hashfile->name.mb_str(*wxConvCurrent) << endl;
        // TODO: What we are supposed to do if the following does fail?
        newrecord->CreateFromFile(hashfile->directory, hashfile->name, &m_endWaitingForHashList);

        if (!m_endWaitingForHashList)
        {
            wxCommandEvent evt(wxEVT_COMMAND_MENU_SELECTED, TM_FINISHEDHASHING);
            std::pair<CKnownFile *, CPartFile *>* xmitted_data = new std::pair<CKnownFile *, CPartFile *>(newrecord, hashfile->owner);
            evt.SetClientData(xmitted_data);
            wxPostEvent(theApp.xmuledlg, evt);
        }

        delete hashfile;
    }
}

int CAddFileThread::GetCount()
{
    return m_sWaitingForHashList.GetCount();
}


