// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef CLIENTLIST_H
#define CLIENTLIST_H

#include "mfc.h"                            // CTypedPtrList - audited 4 Nov 2004

#include <map>                              // std::map
#include <stdint.h>                         // uint8_t uint16_t uint32_t

class CClientReqSocket;
class CUpDownClient;

class CClientList
{
public:
    CClientList();
    ~CClientList();
    void AddClient(CUpDownClient* toadd,bool bSkipDupTest = false);
    void RemoveClient(CUpDownClient* toremove);
    void GetStatistics(uint32_t &totalclient, int stats[], std::map<uint16_t, uint32_t>* clientVersionEDonkey = NULL, std::map< uint16_t, uint32_t >* clientVersionEDonkeyHybrid = NULL, std::map< uint8_t, uint32_t >* clientVersionEMule = NULL);
    void DeleteAll();
    bool AttachToAlreadyKnown(CUpDownClient** client, CClientReqSocket* sender);
    CUpDownClient* FindClientByIP(uint32_t clientip,uint16_t port);
    CUpDownClient* FindClientByUserHash(unsigned char* clienthash);
    CUpDownClient* VUGetRandomClient();
    bool VerifyUpload(uint32_t clientip,uint16_t port);
    bool Debug_IsValidClient(CUpDownClient* tocheck);
    void Debug_SocketDeleted(CClientReqSocket* deleted);

private:
    CTypedPtrList<CPtrList, CUpDownClient*> list;
};

#endif
