// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef CLIENTUDP_H
#define CLIENTUDP_H

#include "mfc.h"                            // Needed for CTypedPtrList - audited 4 Nov 2004

#include <stdint.h>                         // Needed for uint16_t
#include <wx/socket.h>                      // Needed for wxDatagramSocket

class Packet;
class UDPPack;
class wxEvtHandler;

#pragma pack(1)
struct UDPPack{
    Packet*  packet;
    uint32_t dwIP;
    uint16_t nPort;
    int      trial;
};
#pragma pack()

class CClientUDPSocket: public wxDatagramSocket
{
  DECLARE_DYNAMIC_CLASS(CClientUDPSocket)
    CClientUDPSocket(): wxDatagramSocket(useless2) {};
public:
    CClientUDPSocket(wxIPV4address address);
    virtual ~CClientUDPSocket();
    bool SendPacket(Packet* packet, uint32_t dwIP, uint16_t nPort);
    bool IsBusy()	{return m_bWouldBlock;}
    bool Create();
protected:
    bool ProcessPacket(unsigned char* packet, int16_t size, wxUint8 opcode, wxUint32 hostip, uint16_t port);
    
 public:
    virtual void OnSend(int nErrorCode);
    virtual void OnReceive(int nErrorCode);
private:
    void ClearQueues();
    bool SendTo(char* lpBuf, int nBufLen, uint32_t dwIP, uint16_t nPort);
    bool m_bWouldBlock;

    CTypedPtrList<CPtrList, UDPPack *> controlpacket_queue;
    wxIPV4address  useless2;

    wxEvtHandler* m_event_handler;
};




#endif
