// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "CommentDialogLst.h"
#	include "muuli_wdr.h"
#	include "otherfunctions.h"
#	include "PartFile.h"
#	include "updownclient.h"
#	include "wintypes.h"
#	include "xmule.h"
#endif

#include <wx/dialog.h>
#include <wx/settings.h>

#include "wx/xrc/xmlres.h"
#include "wx/xrc/xh_all.h"

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)


BEGIN_EVENT_TABLE(CCommentDialogLst, wxDialog)
    EVT_BUTTON(XRCID("IDCOK"), CCommentDialogLst::OnBnClickedApply)
    EVT_BUTTON(XRCID("IDCREF"), CCommentDialogLst::OnBnClickedRefresh)
END_EVENT_TABLE()


CCommentDialogLst::CCommentDialogLst(wxWindow *parent, CPartFile *file):
    wxDialog(parent, CCommentDialogLst::IDD, _("File Comments"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    m_file = file;
    //wxSizer* content=commentLstDlg(this,TRUE);
    //content->Show(this,TRUE);
    wxPanel *content = wxXmlResource::Get()->LoadPanel(this, wxT("DLG_COMMENTLST"));
    SetSize(content->GetSize());
    content->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    Centre();
    pmyListCtrl = XRCCTRL( *this, "IDC_LST", wxListCtrl);
    OnInitDialog();
}

CCommentDialogLst::~CCommentDialogLst()
{
}

void CCommentDialogLst::OnBnClickedApply(wxCommandEvent &evt)
{
    //CDialog::OnOK();
    EndModal(0);
}

void CCommentDialogLst::OnBnClickedRefresh(wxCommandEvent &evt)
{
    CompleteList();
}

bool CCommentDialogLst::OnInitDialog()
{
    //CDialog::OnInitDialog();
    pmyListCtrl->InsertColumn(0, GetResString(IDS_CD_UNAME), wxLIST_FORMAT_LEFT, 130);
    pmyListCtrl->InsertColumn(1, GetResString(IDS_DL_FILENAME), wxLIST_FORMAT_LEFT, 130);
    pmyListCtrl->InsertColumn(2, GetResString(IDS_QL_RATING), wxLIST_FORMAT_LEFT, 80);
    pmyListCtrl->InsertColumn(3, GetResString(IDS_COMMENT), wxLIST_FORMAT_LEFT, 340);
    Localize();
    CompleteList();
    return TRUE;
}

void CCommentDialogLst::Localize(void)
{
    GetDlgItem(IDCOK, wxControl)->SetLabel(GetResString(IDS_CW_CLOSE));
    GetDlgItem(IDCREF, wxControl)->SetLabel(GetResString(IDS_CMT_REFRESH));
    SetTitle(GetResString(IDS_CMT_READALL) + wxT(" (") + wxString(m_file->GetFileName(), *wxConvCurrent) + wxT(")"));
}

void CCommentDialogLst::CompleteList()
{
    POSITION pos1, pos2;
    CUpDownClient* cur_src;
    int count = 0;
    pmyListCtrl->DeleteAllItems();

    for (pos1 = m_file->srclist.GetHeadPosition(); (pos2 = pos1) != NULL;)
    {
        m_file->srclist.GetNext(pos1);
        cur_src = m_file->srclist.GetAt(pos2);

        if (cur_src->GetFileComment().Length() > 0 || cur_src->GetFileRate() > 0)
        {
            pmyListCtrl->InsertItem(count, wxString(cur_src->GetUserName(), *wxConvCurrent));
            pmyListCtrl->SetItem(count, 1, wxString(cur_src->GetClientFilename(), *wxConvCurrent));
            pmyListCtrl->SetItem(count, 2, GetRateString(cur_src->GetFileRate()));
            pmyListCtrl->SetItem(count, 3, cur_src->GetFileComment());
            count++;
        }
    }

    wxString info = wxT("");

    if (count == 0) 
    {
        info = wxT("(") + GetResString(IDS_CMT_NONE) + wxT(")");
    }

    GetDlgItem(IDC_CMSTATUS, wxControl)->SetLabel(info);
    m_file->UpdateFileRatingCommentAvail();
}

