// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _DOWNLOADLISTCTRL_H_
#define _DOWNLOADLISTCTRL_H_

#include "mfc.h"                       // CTypedPtrList
#include "MuleListCtrl.h"              // CMuleListCtrl

#include <list>                        // std::list
#include <map>                         // std::multimap
#include <stdint.h>                    // uint16_t
#include <utility>                     // std::pair

class CPartFile;
class CUpDownClient;
class CtrlItem_Struct;

class CDownloadListCtrl: public CMuleListCtrl
{
    DECLARE_DYNAMIC_CLASS(CDownloadListCtrl)

public:
    CDownloadListCtrl();
    CDownloadListCtrl(wxWindow*& parent,int id,const wxPoint& pos,wxSize siz,int flags);
    virtual ~CDownloadListCtrl();

    uint8_t curTab;
    void UpdateItem(void* toupdate);
    void Init();
    void InitSort();
    void AddFile(CPartFile* toadd);
    void AddSource(CPartFile* owner,CUpDownClient* source,bool notavailable);
    void RemoveSource(CUpDownClient* source,CPartFile* owner);
    void RemoveFile(CPartFile* toremove);
    void ClearCompleted();
    void SetStyle();
    void CreateMenues();
    void Localize();
    void HideSources(CPartFile* toCollapse,bool isShift = false,bool isCtrl = false,bool isAlt = false);
    void ShowFilesCount();
    void ChangeCategory(int newsel);
    wxString getTextList();
    wxString getListforDaemon ();

    void ShowSelectedFileDetails();

    void HideFile(CPartFile* tohide);
    void ShowFile(CPartFile* tohide);

    // lagloose
    bool isShift;
    void OnKeyUp(wxKeyEvent& event);
    void OnKeyDown(wxKeyEvent& event);
    // end lagloose

    virtual void OnDrawItem(int item,wxDC* dc,const wxRect& rect,const wxRect& rectHL,bool highlighted);

protected:
    void OnColResize(wxODListEvent& evt);
    void OnColumnClick(wxODListEvent& evt);
    void OnNMRclick(wxODListEvent& evt);

    void DrawFileItem(wxDC* dc,int nColumn,x::LPRECT lpRect, CtrlItem_Struct* lpCtrlItem);
    void DrawSourceItem(wxDC* dc,int nColumn,x::LPRECT lpRect, CtrlItem_Struct* lpCtrlItem);
    static int SortProc(long lp1,long lp2,long lpSort);
    static int Compare(CPartFile* file1, CPartFile* file2, long lParamSort);
    static int Compare(CUpDownClient* client1, CUpDownClient* client2, long lParamSort,int sortMod);

    void OnLvnItemActivate(wxODListEvent& evt);
    void OnPriLow(wxCommandEvent& evt);
    void OnPriNormal(wxCommandEvent& evt);
    void OnPriHigh(wxCommandEvent& evt);
    void OnMCancel(wxCommandEvent& evt);

    bool ProcessEvent(wxEvent& evt);

    void setPri(int newpri);
    void collectSelections(std::list<CPartFile *>* selections);

private:
    int m_cat_count;
    void HandleCatClick(wxCommandEvent* event);
    bool ShowItemInCurrentCat(CPartFile* file,int newsel);

    typedef std::pair<void*,CtrlItem_Struct*> ListItemsPair;
    typedef std::multimap<void*,CtrlItem_Struct*> ListItems;
    ListItems m_ListItems;

    wxImageList m_ImageList;
    wxMenu* m_ClientMenu;
    wxMenu* m_PrioMenu;
    wxMenu* m_FileMenu;
    wxBrush* m_hilightBrush,*m_hilightUnfocusBrush;
DECLARE_EVENT_TABLE()
};

#endif // _DOWNLOADLISTCTRL_H_
