// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _DOWNLOADQUEUE_H_
#define _DOWNLOADQUEUE_H_

#include "resource.h"                  // IDD_TRANSFER
#include "wintypes.h"                  // x::DWORD
#include "mfc.h"                       // CTypedPtrList, CList

#include <stdint.h>                    // uint16_t
#include <wx/string.h>                 // wxString

class CED2KFileLink;
class CPartFile;
class CPreferences;
class CSafeMemFile;
class CSearchFile;
class CServer;
class CSharedFileList;
class CUpDownClient;

class CDownloadQueue
{
    friend class CAddFileThread;
    friend class CServerSocket;
public:
    CDownloadQueue(CPreferences* in_prefs, CSharedFileList* in_sharedfilelist);
    ~CDownloadQueue();
    void Process();
    void Init();
    void AddSearchToDownload(CSearchFile* toadd);
    void AddSearchToDownload(wxString link);
    void AddFileLinkToDownload(class CED2KFileLink* pLink);
    bool IsFileExisting(unsigned char* fileid);
    bool IsPartFile(void* totest);
    CPartFile* GetFileByID(unsigned char* filehash);
    CPartFile* GetFileByIndex(int idx);
    void CheckAndAddSource(CPartFile* sender,CUpDownClient* source);
    void CheckAndAddKnownSource(CPartFile* sender,CUpDownClient* source);
    bool RemoveSource(CUpDownClient* toremove, bool updatewindow = true);
    void DeleteAll();
    void RemoveFile(CPartFile* toremove);
    uint32_t GetDatarate() { return datarate; }
    void SortByPriority();
    void StopUDPRequests();
    CServer* cur_udpserver;
    void GetDownloadStats(int results[]);
    void AddPartFilesToShare();
    void AddDownload(CPartFile* newfile);
    CUpDownClient*  GetDownloadClientByIP(uint32_t dwIP);
    void UpdateDisplayedInfo(bool force=false);
    void StartNextFile();
    void AddDownDataOverheadSourceExchange(uint32_t data) { m_nDownDataRateMSOverhead += data;
                                                            m_nDownDataOverheadSourceExchange += data;
                                                            m_nDownDataOverheadSourceExchangePackets++; }
    void AddDownDataOverheadFileRequest(uint32_t data) { m_nDownDataRateMSOverhead += data;
                                                         m_nDownDataOverheadFileRequest += data;
                                                         m_nDownDataOverheadFileRequestPackets++; }
    void AddDownDataOverheadServer(uint32_t data) { m_nDownDataRateMSOverhead += data;
                                                    m_nDownDataOverheadServer += data;
                                                    m_nDownDataOverheadServerPackets++; }
    void AddDownDataOverheadOther(uint32_t data) { m_nDownDataRateMSOverhead += data;
                                                   m_nDownDataOverheadOther += data;
                                                   m_nDownDataOverheadOtherPackets++; }
    void AddLinksFromFile();

    uint32_t GetDownDatarateOverhead() { return m_nDownDatarateOverhead; }
    uint64_t GetDownDataOverheadSourceExchange() { return m_nDownDataOverheadSourceExchange; }
    uint64_t GetDownDataOverheadFileRequest() { return m_nDownDataOverheadFileRequest; }
    uint64_t GetDownDataOverheadServer() { return m_nDownDataOverheadServer; }
    uint64_t GetDownDataOverheadOther() { return m_nDownDataOverheadOther; }
    uint64_t GetDownDataOverheadSourceExchangePackets() { return m_nDownDataOverheadSourceExchangePackets; }
    uint64_t GetDownDataOverheadFileRequestPackets() { return m_nDownDataOverheadFileRequestPackets; }
    uint64_t GetDownDataOverheadServerPackets() { return m_nDownDataOverheadServerPackets; }
    uint64_t GetDownDataOverheadOtherPackets() { return m_nDownDataOverheadOtherPackets; }
    void CompDownDatarateOverhead();
    int GetFileCount() { return filelist.GetCount(); }
    void ResetCatParts(int cat);
    void SavePartFiles(bool del = false);   // InterCeptor
    void SetCatPrio(int cat, uint8_t newprio);
    void SetCatStatus(int cat, int newstatus);

protected:
    bool SendNextUDPPacket();
    int GetMaxFilesPerUDPServerPacket() const;
    bool SendGlobGetSourcesUDPPacket(CSafeMemFile& data);

private:
    CTypedPtrList<CPtrList, CPartFile*> filelist;
    CSharedFileList* sharedfilelist;
    CPreferences* app_prefs;
    uint16_t filesrdy;
    uint32_t datarate;

    CPartFile* lastfile;
    uint32_t lastudpsearchtime;
    uint32_t lastudpstattime;
    uint32_t m_nLastED2KLinkCheck;
    uint8_t udcounter;
    uint8_t m_cRequestsSentToServer;
    int m_iSearchedServers;

    uint32_t m_nDownDatarateOverhead;
    uint32_t m_nDownDataRateMSOverhead;
    uint64_t m_nDownDataOverheadSourceExchange;
    uint64_t m_nDownDataOverheadSourceExchangePackets;
    uint64_t m_nDownDataOverheadFileRequest;
    uint64_t m_nDownDataOverheadFileRequestPackets;
    uint64_t m_nDownDataOverheadServer;
    uint64_t m_nDownDataOverheadServerPackets;
    uint64_t m_nDownDataOverheadOther;
    uint64_t m_nDownDataOverheadOtherPackets;
    CList<int,int> m_AvarageDDRO_list;

    x::DWORD m_lastRefreshedDLDisplay;

public:
    /* RemoveSourceFromPartFile function */
    void  RemoveSourceFromPartFile(CPartFile* file, CUpDownClient* client, POSITION position);
    /* DisableAnyA4AFAuto function */
    void  DisableAnyA4AFAuto(void);
};

#endif // _DOWNLOADQUEUE_H_
