// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _FRIEND_H_
#define _FRIEND_H_

#include <stdint.h>                    // uint16_t
#include <wx/string.h>                 // wxString

#define FF_NAME     0x01

class CFile;
class CUpDownClient;

class CFriend
{
public:
    CFriend();
    CFriend(CUpDownClient* client);
    CFriend( unsigned char t_m_abyUserhash[16], uint32_t tm_dwLastSeen, uint32_t tm_dwLastUsedIP, uint32_t tm_nLastUsedPort, uint32_t tm_dwLastChatted, wxString tm_strName, uint32_t tm_dwHasHash);
    ~CFriend();
    unsigned char m_abyUserhash[16];
    uint32_t m_dwLastSeen;
    uint32_t m_dwLastUsedIP;
    uint32_t m_nLastUsedPort;
    uint32_t m_dwLastChatted;
    uint32_t m_dwHasHash;
    wxString m_strName;

    CUpDownClient* m_LinkedClient;

    void LoadFromFile(CFile* file);
    void WriteToFile(CFile* file);
};

#endif // _FRIEND_H_
