// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "wintypes.h"
#	include "xmule.h"
#	include "HTTPDownloadDlg.h"
#	include "otherfunctions.h"
#	include "animate.h"
#	include "muuli_wdr.h"
#endif

#include "inetdownload.h"

#include <wx/msgdlg.h>                      // Needed for wxMessageDialog
#include <wx/sizer.h>                       // Needed for wxSizer
#include <sstream>

BEGIN_EVENT_TABLE(CHTTPDownloadDlg, wxDialog)
    EVT_BUTTON(ID_CANCEL, CHTTPDownloadDlg::OnBtnCancel)
END_EVENT_TABLE()

CHTTPDownloadDlg::CHTTPDownloadDlg(wxWindow *parent, wxString url, wxString tempName)
: wxDialog(parent, 1025, _("Downloading..."), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    std::ostringstream internalbuffer;
    wxSizer *content = downloadDlg(this, TRUE);
    wxGIFAnimationCtrl *ani = (wxGIFAnimationCtrl *) FindWindowById(ID_ANIMATE);
    //ani->LoadFile("pixmaps/tiku.gif");
    ani->LoadData((char *) inetDownload, sizeof(inetDownload));
    //ani->GetPlayer().UseParentBackground(true);
    ani->GetPlayer() .UseBackgroundColour(true);
    ani->Play();
    content->Show(this, TRUE);
    Centre();
    process = new myWGetProcess(this);
    internalbuffer << "wget -O '" << tempName.mb_str(*wxConvCurrent) << "' '" << url.mb_str(*wxConvCurrent) << "'";
    wxString cmd = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    if (wxExecute(cmd, wxEXEC_ASYNC, process) < 1)
    {
        wxMessageBox(_("Can't spawn wget. You should have it\nin your $PATH."), _("Error"), wxCENTRE |wxOK |wxICON_ERROR);
    }
}

void CHTTPDownloadDlg::OnBtnCancel(wxCommandEvent &evt)
{
    // terminate wget
    if (process)
    {
        process->Detach();
    }
    EndModal(ID_CANCEL);
}

void myWGetProcess::OnTerminate(int pid, int status)
{
    // ok. it's time to close the window
 /*  This code causes a continuous loop if wget is unsuccessful.
 if(status!=0) {
 // error
 wxString mystr=wxString::Format(_("wget returned error %d.\nServerlist was not updated."),status);
 wxMessageBox(mystr,_("Error"),wxCENTRE|wxOK|wxICON_ERROR);
    }*/
    myDlg->EndModal(status);
}

