// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef MAPKEY_H
#define MAPKEY_H

#include "mfc.h"                            // Needed for HashKey - audited 5 Nov 2004

#include <stdint.h>                         // Needed for uint32_t
#include <wx/object.h>                      // Needed for wxObject

class CCKey : public wxObject{
public:
	CCKey(unsigned char* key = 0)		{m_key = key;}
	CCKey(const CCKey& k1)		{m_key = k1.m_key;}

	friend bool operator<(const CCKey& k1,const CCKey&k2)
	{
		return memcmp(k1.m_key, k2.m_key, 16) < 0;
	}

	CCKey& operator=(const CCKey& k1)						{m_key = k1.m_key; return *this; }
	friend bool operator==(const CCKey& k1,const CCKey& k2)	{return !memcmp(k1.m_key,k2.m_key,16);}
	
	unsigned char* m_key;
};

template<> inline unsigned int HashKey(CCKey key){
   uint32_t hash = 1;
   for (int i = 0;i != 16;i++)
	   hash += (key.m_key[i]+1)*((i*i)+1);
   return hash;
};

#endif
