// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "listctrl_gen.h"
#include "MuleListCtrl.h"                   // Needed for this Interface's Prototype
#include "opcodes.h"                        // Needed for MP_LISTCOL_1
#include "Preferences.h"                    // Needed for CPreferences::SetColumnWidth
#include "xmule.h"                          // Needed for theApp

#include <sstream>                          // Needed for std::istringstream
#include <wx/menu.h>                        // Needed for wxMenu

#define MLC_MENU 650

#include <wx/window.h>
#include <DynPrefs/DynPrefs.h> // Needed for DynamicPreferences

#include <iostream>
using namespace std;

BEGIN_EVENT_TABLE(CMuleListCtrl, wxODListCtrl)
    EVT_ODLIST_COL_RIGHT_CLICK(-1, CMuleListCtrl::OnColumnRclick)
    EVT_ODLIST_COL_END_DRAG(-1, CMuleListCtrl::OnFinishResize)
END_EVENT_TABLE()

IMPLEMENT_DYNAMIC_CLASS(CMuleListCtrl, wxODListCtrl)
CMuleListCtrl::CMuleListCtrl()
{
    m_bCustomDraw = false;
    m_iCurrentSortItem = - 1;
    m_iColumnsTracked = 0;
    m_aColumns = NULL;
#if defined(__WXGTK__)
    m_col_minsize = 10;
#elif defined(__WXMSW__)
    m_col_minsize = 0;
#else
#error Need to set col_minsize for ur OS
#endif
}

CMuleListCtrl::CMuleListCtrl(std::string list_name, wxWindow *&parent, int id, const wxPoint &pos, wxSize siz, int flags)
: wxODListCtrl(parent, id, pos, siz, flags)
{
    m_name = list_name;
    m_bCustomDraw = false;
    m_iCurrentSortItem = - 1;
    m_iColumnsTracked = 0;
    m_aColumns = NULL;
#if defined(__WXGTK__)
    m_col_minsize = 10;
#elif defined(__WXMSW__)
    m_col_minsize = 0;
#else
#error Need to set col_minsize for ur OS
#endif
}

CMuleListCtrl::~CMuleListCtrl()
{
    if (m_aColumns != NULL)
    delete[] m_aColumns;
}

void CMuleListCtrl::SetNamxMule(x::LPCTSTR lpszName)
{
    m_Name = wxString((const char *)lpszName, *wxConvCurrent);
}

void CMuleListCtrl::SetSortArrow(int iColumn, ArrowType atType)
{
    // integrated in listctrl..
    switch (atType)
    {
    case 263:
        wxODListCtrl::SetSortArrow(iColumn, (int) 1);
        break;
    default:
        wxODListCtrl::SetSortArrow(iColumn, (int) 2);
        break;
    }
}

bool CMuleListCtrl::ProcessEvent(wxEvent& evt)
{
    if ((evt.GetEventType() == wxEVT_COMMAND_MENU_SELECTED) && (evt.GetId() >= MP_LISTCOL_1) && (evt.GetId() <= MP_LISTCOL_15))
    {
        int col = evt.GetId() - MP_LISTCOL_1;

        if (wxODListCtrl::GetColumnWidth(col) > m_col_minsize)
        {
            SetColumnWidth(col, 0);
        }
        else
        {
            SetColumnWidth(col, wxODLIST_AUTOSIZE);
        }

        OnFinishResize(evt);
    }

    return wxODListCtrl::ProcessEvent(evt);
}

void CMuleListCtrl::OnColumnRclick(wxODListEvent &evt)
{
    m_ColumnMenu = new wxMenu();
    wxODListItem item;

    for (int a = 0 ; a < GetColumnCount() ; a++)
    {
        GetColumn(a, item);
        m_ColumnMenu->AppendCheckItem(a + MP_LISTCOL_1, item.GetText());
        m_ColumnMenu->Check(a + MP_LISTCOL_1, wxODListCtrl::GetColumnWidth(a) > m_col_minsize ? true: false);
    }

    PopupMenu(m_ColumnMenu, evt.GetPoint());
}

void CMuleListCtrl::OnFinishResize(wxEvent& evt)
{
    int col_count = GetColumnCount();
    std::ostringstream sout;

    for (int a = 0; a < col_count; ++a)
    {
        sout << GetColumnWidth(a);

        if (a < col_count - 1)
        {
            sout << ",";
        }
    }

    DynPrefs::Add(m_name + "-cols", wxString(sout.str().c_str(), wxConvUTF8));
}

int CMuleListCtrl::LoadColumnWidths()
{
    std::string prefname(m_name);
    prefname += "-cols";

    wxString buffer = DynPrefs::Get<wxString>(prefname);

    int loc = wxString::npos;
    int holder;
    int count = 0;
    int col_count = GetColumnCount();

    while (count < col_count && (loc = buffer.find(wxT(","))) != wxString::npos)
    {
        std::istringstream sin;
        std::ostringstream sout;

        sout << buffer.SubString(0, loc).mb_str(*wxConvCurrent);
        sin.str(sout.str().c_str());
        sin >> holder;

        SetColumnWidth(count, holder);

        buffer.erase(0, loc + 1);
        ++count;
    }

    return 0;
}

std::pair<int, bool> CMuleListCtrl::GetSortInfo()
{
    wxString pref = DynPrefs::Get<wxString>(m_name + "-sort");

    int loc = pref.find(wxT(" "));
    int col = 0;
    int sort = 0;
    
    if (loc == wxString::npos)
    {
        return std::make_pair(0, true);
    }

    std::istringstream sin;
    std::ostringstream sout;
    sout << pref.mb_str(*wxConvCurrent);
    sin.str(sout.str().c_str());
    sin >> col;
    sin >> sort;

    return std::make_pair(col, sort);
}

void CMuleListCtrl::SaveSortInfo(int col, bool sort)
{
    std::ostringstream sout;
    sout << col << " " << sort;
    DynPrefs::Add(m_name + "-sort", wxString(sout.str().c_str(), wxConvUTF8));
}
