// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef MULELISTCTRL_H
#define MULELISTCTRL_H

#include "resource.h"                       // Needed for IDB_DOWN
#include "wintypes.h"                       // Needed for bool
#include "listctrl.h"                       // Needed for wxODListCtrl

#include <string>                           // Needed for std::string
#include <wx/event.h>                       // Needed for DECLARE_DYNAMIC_CLASS

class CMuleListCtrl : public wxODListCtrl
{
  DECLARE_DYNAMIC_CLASS(CMuleListCtrl)

public:
	CMuleListCtrl();
	CMuleListCtrl(std::string list_name, wxWindow*& parent, int id, const wxPoint& pos,wxSize siz, int flags);
	virtual ~CMuleListCtrl();

	// Sets the list name, used for hide/show menu
	void SetNamxMule(x::LPCTSTR lpszName);


	// check to see if the column is hidden
	bool IsColumnHidden(int iColumn) const {
		if(iColumn < 1 || iColumn >= m_iColumnsTracked)
			return false;

		return m_aColumns[iColumn].bHidden;
	}

	// Get the correct column width even if column is hidden

	enum ArrowType { arrowDown = IDB_DOWN, arrowUp = IDB_UP,
		arrowDoubleDown = IDB_DOWN2X, arrowDoubleUp = IDB_UP2X };
	DECLARE_EVENT_TABLE()
protected:
    std::string m_name;
	virtual bool ProcessEvent(wxEvent& evt);

    void         SetSortArrow(int iColumn, ArrowType atType);
	void         SetSortArrow(int iColumn, bool bAscending) {
		SetSortArrow(iColumn, bAscending ? arrowUp : arrowDown);
	}

	wxString          m_Name;
	wxMenu *m_ColumnMenu;
	bool             m_bCustomDraw;
	x::COLORREF         m_crWindow;
	x::COLORREF         m_crWindowText;
	x::COLORREF         m_crHighlight;
	x::COLORREF         m_crFocusLine;
	x::COLORREF         m_crNoHighlight;
	x::COLORREF         m_crNoFocusLine;
	void OnColumnRclick(wxODListEvent& evt);
    void OnFinishResize(wxEvent& evt);
    int LoadColumnWidths();
    std::pair<int, bool> GetSortInfo();
    void SaveSortInfo(int col, bool sort);

private:
	//static int IndexToOrder(CHeaderCtrl* pHeader, int iIndex);

	struct MULE_COLUMN {
		int iWidth;
		int iLocation;
		bool bHidden;
	};

	int          m_iColumnsTracked;
	MULE_COLUMN *m_aColumns;

	int GetHiddenColumnCount() const {
		int iHidden = 0;
		for(int i = 0; i < m_iColumnsTracked; i++)
			if(m_aColumns[i].bHidden)
				iHidden++;
		return iHidden;
	}

	int       m_iCurrentSortItem;
	ArrowType m_atSortArrow;

	int m_col_minsize;
};
#endif
