// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "MuleNotebook.h"                   // Needed for this Interface's Prototype

IMPLEMENT_DYNAMIC_CLASS(CMuleNotebook, wxNotebook)

BEGIN_EVENT_TABLE(CMuleNotebook, wxNotebook)
    EVT_RIGHT_DOWN(CMuleNotebook::OnRightClick)
END_EVENT_TABLE()

CMuleNotebook::CMuleNotebook(): wxNotebook() { }

CMuleNotebook::CMuleNotebook(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style, const wxString& name)
    : wxNotebook(parent, id, pos, wxDefaultSize, style, name) { }

void CMuleNotebook::OnRightClick(wxMouseEvent& WXUNUSED(event))
{
    wxMouseEvent evt(wxEVT_RIGHT_DOWN);

    if (this->GetMouseListener())
    {
        evt.SetEventObject(this);
        this->GetMouseListener()->AddPendingEvent(evt);
    }
}
