// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#include "config.h"                         // HAVE_MALLOC_H

#include <wx/wx.h>
#include <wx/sckaddr.h>
#include <wx/filesys.h>
#include <wx/fs_zip.h>
#include <wx/wfstream.h>

#include <iomanip>                          // std::setfill
#include <iostream>                         // std::cout
#include <netdb.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "xmule.h"

#include "ClientCredits.h"
#include "NewFunctions.h"
#include "otherfunctions.h"

using std::cout;
using std::endl;

uint32_t globaldata2 = 0;

uint32_t MapData(MAP * pos)
{
    return pos->Data;
}

void md4printf(const void * hash)
{
    cout << "md4hash: ";

//    for (int i = 0 ; i < 16 ; i++)
//    {
//        cout << std::setfill('0') << std::setw(2) << std::hex << static_cast<unsigned char *>(hash[i]);
        cout << "This is currently broken :-//" << endl;
//    }

    cout << endl;
}

unsigned char * pckprintf(char * info)
{
    int s, c;
    unsigned char * t, * c0;
    c0 = (unsigned char *) info;
    s = strlen(info);
    t = (unsigned char *) malloc(1 + (s >> 1));
    for (int i = 0 ; i < s ; i++)
    {
        c = c0 [i];
        if ((c >= 'a') && (c <= 'z'))
        {
            c = c - 'a' + 10;
        }
        else if((c >= '0') && (c <= '9'))
        {
            c = c - '0';
        }

        if (i & 1)
        {
            t[i >> 1] += c & 15;
        }
        else
        {
            t[i >> 1] = (c & 15) <<4;
        }
    }
    return t;
}

void hexprintf(char * info, const void * buffer, int length)
{
    cout << info << ":" << endl;
//    for (int i = 0 ; i < length ; i++)
//    {
//        cout << std::setfill('0') << std::setw(2) << std::hex << static_cast<unsigned char *>(buffer[i]);
        cout << "This is currently broken :-//" << endl;
//    }
    cout << endl;
}

void ascprintf(char * info, const void * buffer, int length)
{
    unsigned char c;
    cout << info << ":" << endl;
    for (int i = 0 ; i < length ; i++)
    {
        c = ((unsigned char *) buffer) [i];
        if ((c >= 'a') && (c <= 'z'))
        {
            cout << c;
        }
        else if((c >= 'A') && (c <= 'Z'))
        {
            cout << c;
        }
        else if((c >= '0') && (c <= '9'))
        {
            cout << c;
        }
        else
        {
            cout << ".";
        }
    }
    cout << endl;
}

unsigned char * MapDataKey(MAP * pos)
{
    return pos->Key;
}

void MapData_Init(MAP *& base)
{
    base = (MAP *) malloc(sizeof(MAP));
    base->Key = NULL;
    base->Data = 0;
    base->Data2 = 0;
    base->next = base;
    base->prev = base;
}

uint32_t MapData_GetCount(MAP * base)
{
    return base->Data;
}

void * MapData_GetIt(MAP * pos)
{
    if (pos)
    {
        return(void *) pos->Data;
    }
    else
    {
        return(void *) NULL;
    }
}

MAP * MapData_Find(MAP * base, void * tofind, int length)
{
    MAP * found;
    found = base;
    while (length)
    {
        found = MapData_GetNext(found);
        if (found)
        {
            if (found->Key)
            {
                if (!memcmp(found->Key, tofind, length))
                {
                    length = 0;
                }
            }
            else
            {
                found = NULL;
                length = 0;
            }
        }
        else
        {
            length = 0;
        }
    }
    return found;
}

MAP * MapData_GetNext(MAP * next)
{
    if (next)
    {
        next = next->next;
        if (next->Key == NULL)
        {
            next = NULL;
        }
    }
    else
    {
        next = NULL;
    }
    return next;
}

void MapData_Append(MAP * base, void * data, void * key, int length)
{
    if (!length)
    {
        length = 4;
    }
    MAP * toinsert;
    toinsert = (MAP *) malloc(sizeof(MAP));
    toinsert->Key = (unsigned char *) malloc(length);
    if (globaldata2)
    {
        toinsert->Data2 = globaldata2;
        if (!data)
        {
            toinsert->Data = globaldata2;
        }
        globaldata2 = 0;
    }
    else
    {
        toinsert->Data2 = 0;
    }
    toinsert->Data = (long int) data;
    toinsert->prev = base->prev;
    toinsert->next = base;
    if(key) {
    memcpy(toinsert->Key, key, length);
    } else {
    memcpy(toinsert->Key, &toinsert->Data, length);
    }
    base->prev->next = toinsert;
    base->prev = toinsert;
    base->Data++;
    //return toinsert;
}

void MapData_Insert(MAP * base, void * data, void * key, int length)
{
    if (!length)
    {
        length = 4;
    }
    MAP * toinsert;
    toinsert = (MAP *) malloc(sizeof(MAP));
    toinsert->Key = (unsigned char *) malloc(length);
    if (globaldata2)
    {
        toinsert->Data2 = globaldata2;
        if (!data)
        {
            toinsert->Data = globaldata2;
        }
        globaldata2 = 0;
    }
    else
    {
        toinsert->Data2 = 0;
    }
    toinsert->Data = (long int) data;
    toinsert->prev = base;
    toinsert->next = base->next;
    if(key) {
    memcpy(toinsert->Key, key, length);
    } else {
    memcpy(toinsert->Key, &toinsert->Data, length);
    }
    base->next->prev = toinsert;
    base->next = toinsert;
    base->Data++;
    //return toinsert;
}

MAP * MapData_Remove(MAP * base, MAP * todelete)
{
    MAP * next = NULL;
    if (base->Data)
    {
        free(todelete->Key);
        todelete->Key = NULL;
        todelete->Data = 0;
        next = todelete->next;
        next->prev = todelete->prev;
        next->prev->next = next;
        todelete->next = NULL;
        todelete->prev = NULL;
        free(todelete);
        base->Data--;
    }
    else
    {
        next = todelete;
    }
    return next;
}

void MapData_RemoveAll(MAP * base)
{
    MAP * pos;
    pos = base->next;
    while (pos->Key)
    {
        pos = MapData_Remove(base, pos);
    }
}

// Converts from wxString (ANSI or Unicode) to UTF8
std::string ToUTF8(const wxString &s)
{
    return std::string((const char *) s.mb_str(wxConvUTF8));
}

// Converts from UTF8 to wxString (ANSI or Unicode)
wxString FromUTF8(const std::string &s)
{
    // When conversion to wxString failed because the string is not
    // of type UTF8 (coding error), it falls back to conversion from
    // ANSI to wxString

//    if (wxConvUTF8.MB2WC(NULL, s.c_str(), s.size())==(size_t)-1) {
//        return wxString(ToUTF8(s).c_str(), wxConvUTF8);
//    }
    return wxString(s.c_str(), wxConvUTF8);
}

// Converts from ANSI (wxConvLibc) to UTF8
std::string ToUTF8(const std::string &s)
{
    // Convert to array of wchar_t's to minimize conversion errors
    size_t szOutWC = wxConvLibc.MB2WC(NULL, s.c_str(), 0);
    std::vector<wchar_t> wchBuffer(szOutWC+1);
    wxConvLibc.MB2WC(&*wchBuffer.begin(), s.c_str(), (size_t) wchBuffer.size());
    // Convert from wchar_t's to array of chars to minimize conversion errors
    size_t szOutMB = wxConvUTF8.WC2MB(NULL, &*wchBuffer.begin(), 0);
    std::string sOut(szOutMB, '?');
    // The size + 1 is perfectly legal here because the string always includes a terminating null character
    wxConvUTF8.WC2MB(&*sOut.begin(), &*wchBuffer.begin(), szOutMB+1);
    return sOut;
}

