// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _OSCOPECTRL_H_
#define _OSCOPECTRL_H_

#include <wx/defs.h>                   // wxWidgets definitions
#include <wx/control.h>                // wxControl
#include <wx/timer.h>                  // wxTimer
#include <wx/pen.h>                    // wxPen
#include <wx/brush.h>                  // wxBrush

#include "mfc.h"
#include "wintypes.h"

class wxBitmap;
class wxMemoryDC;

#define RGB(a,b,c) ((a&0xff)<<16|(b&0xff)<<8|(c&0xff))
#define TIMER_OSCOPE 7641

class COScopeCtrl: public wxControl
{
public:
    COScopeCtrl( int NTrends=1, wxWindow* parent=NULL );
    virtual ~COScopeCtrl();

    void AppendPoints(double dNewPoint[], bool bInvalidate = true, bool bAdd2List = true);
    void AppendEmptyPoints(double dNewPoint[], bool bInvalidate = true, bool bAdd2List = true);
    void SetRange(double dLower, double dUpper, int iTrend = 0);
    void SetRanges(double dLower, double dUpper);
    void SetXUnits(wxString string, wxString XMin = wxT(""), wxString XMax = wxT(""));
    void SetYUnits(wxString string, wxString YMin = wxT(""), wxString YMax = wxT(""));
    void SetGridColor(x::COLORREF color);
    void SetPlotColor(x::COLORREF color, int iTrend = 0);
    x::COLORREF GetPlotColor(int iTrend = 0);
    void SetBackgroundColor(x::COLORREF color);
    void InvalidateCtrl(bool deleteGraph = true);
    void DrawPoint();
    void Reset();
    int ReCreateGraph();
    void GetPlotRect(x::RECT& rPlotRect) { rPlotRect = m_rectPlot; }

    bool drawBars;
    bool autofitYscale;
    int m_nXGrids;
    int m_nYGrids;
    int m_nShiftPixels; // amount to shift with each new point
    int m_nTrendPoints;// when you set this to > 0, then plot will
    // contain that much points (regardless of the
    // Trend/control) width drawn on screen !!!

    // Otherwise, if this is -1 (which is default),
    // m_nShiftPixels will be in use
    int m_nMaxPointCnt;
    int m_nYDecimals;

    struct
    {
        wxString XUnits, XMin, XMax;
        wxString YUnits, YMin, YMax;
    } m_str;

    x::COLORREF m_crBackColor; // background color
    x::COLORREF m_crGridColor; // grid color

    struct PlotData_t
    {
        x::COLORREF crPlotColor; // data plot color
        wxPen penPlot;
        double dCurrentPosition; // current position
        double dPreviousPosition; // previous position
        int nPrevY;
        double dLowerLimit; // lower bounds
        double dUpperLimit; // upper bounds
        double dRange; // = UpperLimit - LowerLimit
        double dVerticalFactor;
        CList <float,float> lstPoints;
    };

protected:
    int m_NTrends;

    void OnPaint(wxPaintEvent& evt);
    void OnSize(wxSizeEvent& evt);
    void OnTimer(wxTimerEvent& evt);

    struct CustShiftStruct { // when m_nTrendPoints > 0, this structure will contain needed vars
        int m_nRmndr; // reminder after dividing m_nWidthToDo/m_nPointsToDo
        int m_nWidthToDo;
        int m_nPointsToDo;
    } CustShift;

    PlotData_t* m_PlotData;

    int m_nClientHeight;
    int m_nClientWidth;
    int m_nPlotHeight;
    int m_nPlotWidth;

    x::RECT m_rectClient;
    x::RECT m_rectPlot;
    wxBrush m_brushBack;

    wxMemoryDC* m_dcGrid;
    wxMemoryDC* m_dcPlot;
    wxBitmap* m_pbitmapOldGrid;
    wxBitmap* m_pbitmapOldPlot;
    wxBitmap* m_bitmapGrid;
    wxBitmap* m_bitmapPlot;

    bool m_bDoUpdate;
    wxTimer m_nRedrawTimer;

private:    
    int oldwidth,oldheight;

    DECLARE_EVENT_TABLE()
};

#endif // _OSCOPECTRL_H_
