// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef PREFERENCES_H
#define PREFERENCES_H

//#if wxUSE_UNICODE == 0
#include "MD5Sum.h"                         // MD5Sum - audited 5 Nov 2004
#include "mfc.h"                            // wxString - audited 4 Nov 2004
#include "wintypes.h"                       // bool x::DWORD x::INT x::WORD - audited 4 Nov 2004

#include <ctime>
#include <list>                             // Needed for std::list
#include <stdint.h>                         // uint32_t
#include <wx/version.h>                     // wxCHECK_VERSION

#if wxCHECK_VERSION(2, 5, 0)
    #include <wx/arrstr.h>                  // wxArrayString
#else
    #include <wx/string.h>                  // wxArrayString
#endif

#ifndef MAX_PATH
// *BSD compatibility
#	if (defined(BSD) && (BSD >= 199103))
#		define MAX_PATH MAXPATHLEN
#	else
#		define MAX_PATH 2048
#	endif
#endif

#define DEFAULT_COL_SIZE 65535

// DO NOT EDIT VALUES like making a uint16_t to uint32_t, or insert any value. ONLY append new vars
#pragma pack(1)
struct Preferences_Ext_Struct
{
    int8_t version;
    unsigned char userhash[16];
    x::WINDOWPLACEMENT EmuleWindowPlacement;
};

#pragma pack(1)
struct Category_Struct
{
    wxString incomingpath;
    wxString title;
    wxString comment;
    uint32_t color;
    int prio;
};

#pragma pack(1)
struct Preferences_Struct
{
    int8_t updatenotify;
    int8_t autotakeed2klinks;
    unsigned char userhash[16];
    x::WINDOWPLACEMENT EmuleWindowPlacement;
    int16_t downloadColumnWidths[13];
    int16_t downloadColumnHidden[13];
    x::INT downloadColumnOrder[13];
    int16_t uploadColumnWidths[8];
    int16_t uploadColumnHidden[8];
    x::INT uploadColumnOrder[8];
    int16_t queueColumnWidths[10];
    int16_t queueColumnHidden[10];
    x::INT queueColumnOrder[10];
    int16_t searchColumnWidths[5];
    int16_t searchColumnHidden[5];
    x::INT searchColumnOrder[5];
    int16_t sharedColumnWidths[11];
    int16_t sharedColumnHidden[11];
    x::INT sharedColumnOrder[11];
    int16_t serverColumnWidths[12];
    int16_t serverColumnHidden[12];
    x::INT serverColumnOrder[12];
    int16_t clientListColumnWidths[8];
    int16_t clientListColumnHidden[8];
    x::INT clientListColumnOrder[8];
    uint32_t statcolors[15];
    uint64_t totalDownloadedBytes;
    uint64_t totalUploadedBytes;
    x::WORD languageID;
    int8_t m_iToolDelayTime;
    int8_t splitterbarPosition;
    int8_t useDownloadNotifier;
    int8_t useChatNotifier;
    int8_t useLogNotifier;
    int8_t useSoundInNotifier;
    uint8_t smartidstate;
    bool m_bVerbose;
    bool m_bDisableKnownClientList;
    bool m_bDisableQueueList;
    int8_t versioncheckdays;
    // Barry - Provide a mechanism for all tables to store/retrieve sort order
    char VideoPlayer[256];
    bool moviePreviewBackup;
    bool indicateratings;
    bool showAllNotCats;
    bool watchclipboard;
    bool m_bFirstStart;
    bool m_bCreditSystem;
    bool log2disk;
    bool debug2disk;
    int iMaxLogMessages;
    bool scheduler;
    bool dontcompressavi;
    bool msgonlyfriends;
    bool msgsecure;
    uint8_t filterlevel;
    int m_iCommitFiles;
    uint16_t maxmsgsessions;
    uint32_t versioncheckLastAutomatic;
    char datetimeformat[32];
    // Web Server [kuchin]
    char m_sWebPassword[256];
    char m_sWebLowPassword[256];
    uint16_t m_nWebPort;
    bool m_bWebEnabled;
    bool m_bWebUseGzip;
    int m_nWebPageRefresh;
    bool m_bWebLowEnabled;
    char m_sWebResDir[MAX_PATH];
    bool m_bIsASCWOP;
    bool showCatTabInfos;
    bool resumeSameCat;
    bool dontRecreateGraphs;
    int allcatType;
    bool m_bUseSecureIdent;
    // Madcat - Sources Dropping Tweaks
    bool DropNoNeededSources;
    bool SwapNoNeededSources;
    bool DropFullQueueSources;
    bool DropHighQueueRankingSources;
    int HighQueueRanking;
    int AutoDropTimer;
};

#pragma pack()

class CPreferences
{
    public:
    enum Table
    {
        tableDownload, tableUpload, tableQueue, tableSearch,
        tableShared, tableServer, tableClientList
        };
    wxArrayString shareddir_list;
    std::list<wxString> addresses_list;
    friend class CPreferencesWnd;
    friend class CPPgTweaks;
    friend class CPPgSourcesDropping;
    friend class CPPgGuiTweaks;
    CPreferences();
    ~CPreferences();
    // Load-Save
    bool Load(bool startup);
    bool Save(unsigned char selection_mask);
    // ~/.eMule Line13:Language
    void SetLanguage();
    // ~/.eMule Line 15:ToolTipDelay
    void SetToolTipDelay(int8_t in_m_iToolDelayTime)
    {
        prefs->m_iToolDelayTime = in_m_iToolDelayTime;
    }
    int8_t GetToolTipDelay(void)
    {
        return prefs->m_iToolDelayTime;
    }

    uint16_t GetDefaultMaxConperFive();
    // ~/.emule Line 25:Check4NewVersionDelay
    void SetUpdateDays(int8_t in_versioncheckdays)
    {
        prefs->versioncheckdays = in_versioncheckdays;
    }
    int8_t GetUpdateDays()
    {
        return prefs->versioncheckdays;
    }
    // ~/.eMule Line31:UpdateNotify
    void SetUpdateNotify(bool in_updatenotify)
    {
        prefs->updatenotify = in_updatenotify;
    }
    bool UpdateNotify()
    {
        return prefs->updatenotify;
    }
    // ~/-eMule Line 49:AutoTakeED2KLinks
    void SetAutoTakeED2KLinks(bool in_autotakeed2klinks)
    {
        prefs->autotakeed2klinks = in_autotakeed2klinks;
    }
    bool AutoTakeED2KLinks()
    {
        return prefs->autotakeed2klinks;
    }
    // ~/.eMule Line 61:VideoPlayer
    void SetVideoPlayer(wxString in_VideoPlayer)
    {
        strcpy(prefs->VideoPlayer, in_VideoPlayer.mb_str(*wxConvCurrent));
    }
    char *GetVideoPlayer()
    {
        if (strlen(prefs->VideoPlayer) == 0) return "";
        else return prefs->VideoPlayer;
    }
    // ~/.eMule Line 80:Verbose
    void SetVerbose(bool in_m_bVerbose)
    {
        prefs->m_bVerbose = in_m_bVerbose;
    }
    bool GetVerbose()
    {
        return prefs->m_bVerbose;
    }

    bool IsQueueListDisabled()
    {
        return prefs->m_bDisableQueueList;
    }
    // ~/.eMule Line 87:VideoPreviewBackupped
    void SetMoviePreviewBackup(bool in_moviePreviewBackup)
    {
        prefs->moviePreviewBackup = in_moviePreviewBackup;
    }
    bool IsMoviePreviewBackup()
    {
        return prefs->moviePreviewBackup;
    }
    // ~/.eMule Line 144-155:StatColor0-StatColor12
    void SetStatsColor(int index, uint32_t value)
    {
        prefs->statcolors[index] = value;
    }
    uint32_t GetStatsColor(int index)
    {
        return prefs->statcolors[index];
    }
    void ResetStatsColor(int index);
    // UNSORTED *****************************************************************************
    // Download Categories (Ornis)
    void RemoveCat(int index);
    int AddCat(Category_Struct* cat)
    {
        catMap.Add(cat);
        return catMap.GetCount() - 1;
    }
    int GetCatCount()
    {
        return catMap.GetCount();
    }
    Category_Struct *GetCategory(int index)
    {
        if (index >= 0 &&index < catMap.GetCount()) return catMap.GetAt(index);
        else return NULL;
    }
    wxString& GetCatPath(uint8_t index)
    {
        return catMap.GetAt(index)->incomingpath;
    }
    x::DWORD GetCatColor(int index)
    {
        if ((int) index >= 0 && (int) index < (int) catMap.GetCount()) return catMap.GetAt(index)->color;
        else return 0;
    }
    int GetAllcatType()
    {
        return prefs->allcatType;
    }
    void SetAllcatType(int in)
    {
        prefs->allcatType = in;
    }
    bool ShowAllNotCats()
    {
        return prefs->showAllNotCats;
    }
    bool ShowRatingIndicator()
    {
        return prefs->indicateratings;
    }
    bool WatchClipboard4ED2KLinks()
    {
        return prefs->watchclipboard;
    }
    void InvertShowAllNotCats()
    {
        prefs->showAllNotCats =!prefs->showAllNotCats;
    }
    bool Log2Disk()
    {
        return prefs->log2disk;
    }
    bool Debug2Disk()
    {
        return prefs->debug2disk;
    }
    int GetMaxLogMessages()
    {
        return prefs->iMaxLogMessages;
    }
    unsigned char *GetUserHash()
    {
        return userhash;
    }
    void Add2TotalDownloaded(uint64_t in)
    {
        prefs->totalDownloadedBytes += in;
    }
    void Add2TotalUploaded(uint64_t in)
    {
        prefs->totalUploadedBytes += in;
    }
    uint64_t GetTotalDownloaded()
    {
        return prefs->totalDownloadedBytes;
    }
    uint64_t GetTotalUploaded()
    {
        return prefs->totalUploadedBytes;
    }
    x::WORD GetLanguageID()
    {
        return prefs->languageID;
    }
    int8_t GetSplitterbarPosition()
    {
        return prefs->splitterbarPosition;
    }
    void SetSplitterbarPosition(int8_t pos)
    {
        prefs->splitterbarPosition = pos;
    }
    bool GetUseDownloadNotifier()
    {
        return prefs->useDownloadNotifier;
    }
    bool GetUseChatNotifier()
    {
        return prefs->useChatNotifier;
    }
    bool GetUseLogNotifier()
    {
        return prefs->useLogNotifier;
    }
    bool GetUseSoundInNotifier()
    {
        return prefs->useSoundInNotifier;
    }
    x::WORD GetWindowsVersion();
    bool IsKnownClientListDisabled()
    {
        return prefs->m_bDisableKnownClientList;
    }
    bool IsFirstStart()
    {
        return prefs->m_bFirstStart;
    }
    bool UseCreditSystem()
    {
        return prefs->m_bCreditSystem;
    }
    void SetCreditSystem(bool m_bInCreditSystem)
    {
        prefs->m_bCreditSystem = m_bInCreditSystem;
    }
    int GetCommitFiles()
    {
        return prefs->m_iCommitFiles;
    }
    x::WINDOWPLACEMENT GetEmuleWindowPlacement()
    {
        return prefs->EmuleWindowPlacement;
    }
    void SetWindowLayout(x::WINDOWPLACEMENT in)
    {
        prefs->EmuleWindowPlacement = in;
    }
    uint32_t GetLastVC()
    {
        return prefs->versioncheckLastAutomatic;
    }
    void UpdateLastVC()
    {
        prefs->versioncheckLastAutomatic = time(NULL);
    }
    int GetIPFilterLevel()
    {
        return prefs->filterlevel;
    }
    wxString GetDateTimeFormat()
    {
        return wxString(prefs->datetimeformat, *wxConvCurrent);
    }
    // WebServer
    bool IsSchedulerEnabled()
    {
        return prefs->scheduler;
    }
    bool GetDontCompressAvi()
    {
        return prefs->dontcompressavi;
    }
    bool MsgOnlyFriends()
    {
        return prefs->msgonlyfriends;
    }
    bool MsgOnlySecure()
    {
        return prefs->msgsecure;
    }
    uint16_t GetMsgSessionsMax()
    {
        return prefs->maxmsgsessions;
    }
    bool ShowCatTabInfos()
    {
        return prefs->showCatTabInfos;
    }
    void ShowCatTabInfos(bool in)
    {
        prefs->showCatTabInfos = in;
    }
    bool GetResumeSameCat()
    {
        return prefs->resumeSameCat;
    }
    bool IsGraphRecreateDisabled()
    {
        return prefs->dontRecreateGraphs;
    }
    // Madcat - Sources Dropping Tweaks
    bool DropNoNeededSources()
    {
        return prefs->DropNoNeededSources;
    }
    bool SwapNoNeededSources()
    {
        return prefs->SwapNoNeededSources;
    }
    bool DropFullQueueSources()
    {
        return prefs->DropFullQueueSources;
    }
    bool DropHighQueueRankingSources()
    {
        return prefs->DropHighQueueRankingSources;
    }
    int HighQueueRanking()
    {
        return prefs->HighQueueRanking;
    }
    int GetAutoDropTimer()
    {
        return prefs->AutoDropTimer;
    }

    Preferences_Struct *prefs;

protected:
    bool SaveCats(void);
    bool LoadCats(void);
    bool LoadPreferences(void);
    void SavePreferences(void);
    bool Load_Adresses(void);
    bool Save_Adresses(void);
    bool Load_Shared_Dirs(void);
    bool Save_Shared_Dirs(void);
    void CreateUserHash();
    void SetStandartValues();
    static int GetRecommendedMaxConnections();

private:
//    char appdir[MAX_PATH];
    Preferences_Ext_Struct *prefsExt;
    unsigned char userhash[16];
    x::WORD m_wWinVer;
    CArray < Category_Struct *, Category_Struct *> catMap;
    // deadlake PROXYSUPPORT
    uint16_t ListenPort;
};

#endif
//#endif
