// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "PreferencesDlg.h"                 // Needed for this Interface's Prototype

#include "PPgDirectories.h"                 // Needed for CPPgDirectories
#include "PPgSourcesDropping.h"             // Needed for CPPgSourcesDropping
#include "Preferences.h"                    // CPreferences
#include "xmule.h"                          // Needed for theApp

#include <wx/button.h>                      // Needed for wxButton;
#include <wx/notebook.h>                    // Needed for wxNotebook
#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

IMPLEMENT_DYNAMIC_CLASS(CPreferencesDlg, wxDialog)

BEGIN_EVENT_TABLE(CPreferencesDlg, wxDialog)
    EVT_BUTTON(wxOK, CPreferencesDlg::OnBtnOk)
    EVT_BUTTON(wxCANCEL, CPreferencesDlg::OnBtnCancel)
END_EVENT_TABLE()

CPreferencesDlg::CPreferencesDlg(wxWindow *parent, CPreferences* prefs)
: wxDialog(parent, 9999, _("Preferences"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    OnInit(prefs);
}

void CPreferencesDlg::OnInit(CPreferences* prefs)
{
    //SetFont(wxFont(8,wxSWISS,wxNORMAL,wxNORMAL));
    // here comes brave new resource system
    wxNotebook *book = new wxNotebook(this, 7773, wxPoint(0, 0), wxSize(200, 200));
    // load pages
    // Creating Sources Dropping window:
    m_wndSourcesDropping = new CPPgSourcesDropping(book);
    // Creating GUI Tweaks window:
    wxSize pageSize(520, 460);
    SetSize(pageSize.GetWidth(), pageSize.GetHeight() + 40);
    book->SetSize(pageSize);
    // then the ok/cancel buttons please
    wxButton(this, wxOK, _("OK"), wxPoint(pageSize.GetWidth() - 2 *80 - 16, pageSize.GetHeight() + 10), wxSize(80, 24));
    wxButton(this, wxCANCEL, _("Cancel"), wxPoint(pageSize.GetWidth() - 80 - 8, pageSize.GetHeight() + 10), wxSize(80, 24));
    SetPrefs(prefs);
    Centre();
    // force font small enought to show the pages
    //_setFont(this);
    // now call page initializators
    // no. bad idea. no preferences yet.
    // do it at showmodal instead!
    //m_wndGeneral.LoadSettings();
    Localize();
}

CPreferencesDlg::~CPreferencesDlg()
{
}

int CPreferencesDlg::ShowModal()
{
    // setup pages
    // Load settings in Dropping Sources window:
    m_wndSourcesDropping->LoadSettings();
    // and then do the show
    return wxDialog::ShowModal();
}

void CPreferencesDlg::OnBtnWizard(wxCommandEvent&evt)
{
}

void CPreferencesDlg::OnBtnOk(wxCommandEvent&evt)
{
    // apply all pages
    // OnApply in Sources Dropping:
    m_wndSourcesDropping->OnApply();
    // Save Preferences & Shared Directories
    app_prefs->Save(5);

//    theApp.LoadCompatiblePrefs();

    EndModal(0);
}

void CPreferencesDlg::OnBtnCancel(wxCommandEvent&evt)
{
    EndModal(0);
}

void CPreferencesDlg::SetPrefs(CPreferences* in_prefs)
{
    app_prefs = in_prefs;
    m_wndSourcesDropping->SetPrefs(in_prefs);  // Setting preferences to Sources Dropping
}
