// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef SAFEFILE_H
#define SAFEFILE_H

#include "CFile.h"                          // CFile - audited 5 Nov 2004
#include "CMemFile.h"                       // CMemFile - audited 5 Nov 2004

class CSafeFile : public CFile{
public:
	CSafeFile();
	CSafeFile::CSafeFile(x::LPCSTR lpszFileName,x::UINT nOpenFlags);
	x::UINT Read(void* lpBuf,x::UINT nCount);
};

class CSafeMemFile : public CMemFile{ // memFile
public:
	CSafeMemFile(x::UINT nGrowBytes = 0);
	CSafeMemFile::CSafeMemFile(x::BYTE* lpBuffer,x::UINT nBufferSize,x::UINT nGrowBytes = 0);
	x::UINT Read(void* lpBuf,x::UINT nCount);
};
#endif
