// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef SERVERLIST_H
#define SERVERLIST_H

#include "mfc.h"                            // wxString POSITION - audited 4 Nov 2004
#include "server.h"
#include "opcodes.h"
#include "ServerListCtrl.h"

#include <wx/timer.h>

class CPreferences;
class Packet;

class CServerList
{
	friend class CServerListCtrl;
public:
	CServerList(CPreferences* in_prefs);
	~CServerList(void);
	bool		Init();
	bool		AddServer(CServer* in_server );
	void		RemoveServer(CServer* out_server);
	void		RemoveAllServers(void);
	bool		AddServermetToList(wxString strFile, bool merge = true);
	void		AddServersFromTextFile(wxString strFilename,bool isstaticserver=true);
	bool		SaveServermetToFile(); //<<--9/22/02
	void		ServerStats();
	void		ResetServerPos()	{serverpos = 0;}
	void		ResetSearchServerPos()	{searchserverpos = 0;}
	CServer*	GetNextServer();
	CServer*	GetNextSearchServer();
	CServer*	GetNextStatServer();
	CServer*	GetServerAt(uint32_t pos)	{return list.GetAt(list.FindIndex(pos));}
	uint32_t		GetServerCount()	{return list.GetCount();}
	CServer*	GetNextServer(CServer* lastserver); // slow
	CServer*	GetServerByIP(wxUint32 nIP);
	CServer*	GetServerByIP(wxUint32 nIP,wxUint16 nPort);
	CServer*	GetServerByAddress(const char *address, uint16_t port);
	bool		IsGoodServerIP( CServer* in_server ); //<<--
	void		GetStatus( uint32_t &total, uint32_t &failed, uint32_t &user, uint32_t &file, uint32_t &tuser, uint32_t &tfile, float &occ);
	void		GetUserFileStatus( uint32_t &user, uint32_t &file);
	bool		BroadCastPacket(Packet* packet); //send Packet to all server in the list
	void		CancelUDPBroadcast();
	void		Sort();
	void		MoveServerDown(CServer* aServer);
	uint32_t		GetServerPostion()	{return serverpos;}
	void		SetServerPosition(uint32_t newPosition) { if (newPosition<(uint32_t)list.GetCount() ) serverpos=newPosition; else serverpos=0;}
	uint32_t		GetDeletedServerCount()		{return delservercount;}
	void		Process();
	void		SendNextPacket();

	//void static CALLBACK UDPTimerProc(HWND hwnd, x::UINT uMsg,x::UINT_PTR idEvent,x::DWORD dwTime);
protected:
	void		AutoUpdate();
private:
	uint32_t		serverpos;
	uint32_t		searchserverpos;
	uint32_t		statserverpos;
	uint8_t		version;
	uint32_t		servercount;
	CTypedPtrList<CPtrList, CServer*>	list;
	CPreferences*	app_prefs;
	//uint32_t		udp_timer;
	wxTimer         udp_timer;
	POSITION	broadcastpos;
	Packet*		broadcastpacket;
	uint32_t		delservercount;
	uint32_t		m_nLastSaved;
};

#endif
