// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef SERVERLISTCTRL_H
#define SERVERLISTCTRL_H

#include "MuleListCtrl.h"              // CMuleListCtrl

class CServer;

class serverListItem : public wxODListItem {
 public:
  serverListItem() {};
  ~serverListItem() {};

  CServer* data;
};

// CServerListCtrl
class CServerList; 
class CServerListCtrl : public CMuleListCtrl 
{
  //	DECLARE_DYNAMIC(CServerListCtrl)
public:
	CServerListCtrl();
	CServerListCtrl(wxWindow*& parent,int id,const wxPoint& pos,wxSize siz,int flags);

//	void	ShowServers();
	virtual ~CServerListCtrl();
	bool	Init(CServerList* in_list);
	void InitSort();
	bool	AddServer(CServer* toadd,bool bAddToList = true);
	void	RemoveServer(CServer* todel,bool bDelToList = true);
	bool	AddServermetToList(wxString strFile);
	void	RefreshServer(CServer* server);
	void	RemoveDeadServer();
	//void	Hide() {ShowWindow(SW_HIDE);}
	//void	Visable() {ShowWindow(SW_SHOW);}
	void	Localize();
	void	ShowFilesCount();

	void OnRclickServlist(wxODListEvent& event);
	void OnLDclick(wxMouseEvent& event);
	void OnConnectTo(wxCommandEvent& event);
	void OnCopyLink(wxCommandEvent& event);

    void OnRemove(wxCommandEvent& evt);
	void OnLvnColumnclickServlist(wxODListEvent& evt);
	static int SortProc(long item1,long item2,long sortData);
	bool asc_sort[9]; 
	bool ProcessEvent(wxEvent& evt);

	// Barry - New methods
	bool StaticServerFileAppend(CServer *server);
	bool StaticServerFileRemove(CServer *server);

private:
	CServerList* server_list;
	wxImageList imagelist;
	wxMenu* m_ServerPrioMenu;
	wxMenu* m_ServerMenu;
DECLARE_EVENT_TABLE()
};

#endif
