// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

// Client to Server communication

#ifndef SERVERSOCKET_H
#define SERVERSOCKET_H

#include "EMSocket.h"                       // CEMSocket - audited 5 Nov 2004

#include <stdint.h>                         // uint32_t

class CPreferences;
class CServer;
class CServerConnect;
class Packet;
class wxEvtHandler;

#ifndef ID_SOKETTI
#define ID_SOKETTI 7772
#endif

class CServerSocket : public CEMSocket
{
  DECLARE_DYNAMIC_CLASS(CServerSocket)
    friend class CServerConnect;

    CServerSocket() {};
public:
	CServerSocket(CServerConnect* in_serverconnect);
	~CServerSocket();

	void	ConnectToServer(CServer* server);
	int8_t	GetConnectionState()	{return connectionstate;} 
    wxString info;

 public:
	void	OnConnect(int nErrorCode);
	void	OnLost(int nErrorCode);
	void	OnInput(int nErrorCode);
	void	OnClose(int nErrorCode);
	void	PacketReceived(Packet* packet);

private:
	bool	ProcessPacket(char* packet, int32_t size,int8_t opcode);
	void	SetConnectionState(int8_t newstate);
	CServerConnect*	serverconnect; 
	int8_t	connectionstate;
	CServer*	cur_server;
	bool	headercomplete;
	int32_t	sizetoget;
	int32_t	sizereceived;
	char*	rbuffer;
	bool	m_bIsDeleting;//true: socket is already in deletion phase, don't destroy it in ::StopConnectionTry
    wxEvtHandler* m_event_handler;
};

#endif
