// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#include "SharedFilesCtrl.h"           // Interface Declarations

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "CommentDialog.h"
#	include "muuli_wdr.h"
#	include "otherfunctions.h"
#include "PartFile.h"                       // Needed for PR_NORMAL - audited 5 Nov 2004
#include "Preferences.h"                    // CPreferences::List Settings
#	include "SharedFilesWnd.h"
#	include "xmule.h"
#	include "xmuleDlg.h"
#endif

#include <DynPrefs/DynPrefs.h>              // Needed for DynamicPreferences

#include <wx/msgdlg.h>                      // Needed for wxMessageBox
#include <wx/stattext.h>                    // wxStaticText
#include <iostream>
#include <sstream>

using std::cout;
using std::endl;

#define SYSCOLOR(x) (wxSystemSettings::GetColour(x))

//IMPLEMENT_DYNAMIC(CSharedFilesCtrl, CMuleListCtrl)

BEGIN_EVENT_TABLE(CSharedFilesCtrl, CMuleListCtrl)
    EVT_ODLIST_ITEM_RIGHT_CLICK(ID_SHFILELIST, CSharedFilesCtrl::OnNMRclick)
    EVT_ODLIST_COL_CLICK(ID_SHFILELIST, CSharedFilesCtrl::OnColumnClick)
    EVT_MENU(MP_GETED2KLINK, CSharedFilesCtrl::clickGetED2KLink)
    EVT_MENU(MP_GETHTMLED2KLINK, CSharedFilesCtrl::clickGetED2KLink)
END_EVENT_TABLE()

CSharedFilesCtrl::CSharedFilesCtrl()
{
    // i_a:
    sflist = 0;
    // i_a:
    memset( &sortstat, 0, sizeof(sortstat));
}

CSharedFilesCtrl::~CSharedFilesCtrl()
{
}

CSharedFilesCtrl::CSharedFilesCtrl(wxWindow *&parent, int id, const wxPoint &pos, wxSize siz, int flags)
: CMuleListCtrl("shared_list", parent, id, pos, siz, flags|wxODLC_OWNERDRAW)
{
    // i_a:
    sflist = 0;
    // i_a:
    memset( &sortstat, 0, sizeof(sortstat));
    m_SharedFilesMenu = NULL;
    Init();
}

void CSharedFilesCtrl::InitSort()
{
    std::pair<int, bool> sort_info = GetSortInfo();
    int sortItem = sort_info.first;
    bool sortAscending = sort_info.second;

    SetSortArrow(sortItem, sortAscending);
    SortItems(SortProc, sortItem + (sortAscending ? 0: 100));
}

void CSharedFilesCtrl::Init()
{
    InsertColumn(0, GetResString(IDS_DL_FILENAME), wxODLIST_FORMAT_LEFT, 250);
    InsertColumn(1, GetResString(IDS_DL_SIZE), wxODLIST_FORMAT_LEFT, 100);
    InsertColumn(2, GetResString(IDS_TYPE), wxODLIST_FORMAT_LEFT, 50);
    InsertColumn(3, GetResString(IDS_PRIORITY), wxODLIST_FORMAT_LEFT, 70);
    InsertColumn(4, GetResString(IDS_PERMISSION), wxODLIST_FORMAT_LEFT, 100);
    InsertColumn(5, GetResString(IDS_FILEID), wxODLIST_FORMAT_LEFT, 220);
    InsertColumn(6, GetResString(IDS_SF_REQUESTS), wxODLIST_FORMAT_LEFT, 100);
    InsertColumn(7, GetResString(IDS_SF_ACCEPTS), wxODLIST_FORMAT_LEFT, 100);
    InsertColumn(8, GetResString(IDS_SF_TRANSFERRED), wxODLIST_FORMAT_LEFT, 120);
    InsertColumn(9, GetResString(IDS_UPSTATUS), wxODLIST_FORMAT_LEFT, 120);
    LoadColumnWidths();
    InitSort();
}

void CSharedFilesCtrl::OnNMRclick(wxODListEvent &evt)
{
    // Check if clicked item is selected. If not, unselect all and select it.
    long item = - 1;
    if (!GetItemState(evt.GetIndex(), wxODLIST_STATE_SELECTED))
    {
        for ( ; ;)
        {
            item = GetNextItem(item, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED);
            if (item == - 1) break;
            SetItemState(item, 0, wxODLIST_STATE_SELECTED);
        }
        SetItemState(evt.GetIndex(), wxODLIST_STATE_SELECTED, wxODLIST_STATE_SELECTED);
    }
    if (m_SharedFilesMenu == NULL)
    {
        wxMenu *menu = new wxMenu(GetResString(IDS_SHAREDFILES));
        wxMenu *prioMenu = new wxMenu();
        prioMenu->AppendCheckItem(MP_PRIOVERYLOW, GetResString(IDS_PRIOVERYLOW));
        prioMenu->AppendCheckItem(MP_PRIOLOW, GetResString(IDS_PRIOLOW));
        prioMenu->AppendCheckItem(MP_PRIONORMAL, GetResString(IDS_PRIONORMAL));
        prioMenu->AppendCheckItem(MP_PRIOHIGH, GetResString(IDS_PRIOHIGH));
        prioMenu->AppendCheckItem(MP_PRIOVERYHIGH, GetResString(IDS_PRIORELEASE));
        prioMenu->AppendCheckItem(MP_PRIOAUTO, GetResString(IDS_PRIOAUTO));
        wxMenu *permMenu = new wxMenu();
        permMenu->AppendCheckItem(MP_PERMNONE, GetResString(IDS_FSTATUS_LOCKED));
        permMenu->AppendCheckItem(MP_PERMFRIENDS, GetResString(IDS_FSTATUS_FRIENDSONLY));
        permMenu->AppendCheckItem(MP_PERMALL, GetResString(IDS_FSTATUS_PUBLIC));
        menu->Append(438312, GetResString(IDS_PRIORITY), prioMenu);
        menu->Append(438313, _("Permissions"), permMenu);
        menu->AppendSeparator();
        menu->Append(MP_OPEN, GetResString(IDS_OPENFILE));
        menu->Append(MP_CMT, GetResString(IDS_CMT_ADD));
        menu->AppendSeparator();
        menu->Append(MP_GETED2KLINK, GetResString(IDS_DL_LINK1));
        menu->Append(MP_GETHTMLED2KLINK, GetResString(IDS_DL_LINK2));
        menu->Append(123456789, GetResString(IDS_IRC_ADDLINKTOIRC));
        m_SharedFilesMenu = menu;
    }
    PopupMenu(m_SharedFilesMenu, evt.GetPoint());
}

void CSharedFilesCtrl::Localize()
{
}

void CSharedFilesCtrl::ShowFileList(CSharedFileList *in_sflist)
{
    DeleteAllItems();
    sflist = in_sflist;
    for (CKnownFileMap::iterator pos = sflist->m_Files_map.begin() ; pos != sflist->m_Files_map.end() ; pos++)
    {
        ShowFile(pos->second);
    }
}

void CSharedFilesCtrl::RemoveFile(CKnownFile *toRemove)
{
    int nItem = FindItem( - 1, (long) toRemove);
    if (nItem != - 1)
    DeleteItem(nItem);
    ShowFilesCount();
}

void CSharedFilesCtrl::UpdateFile(CKnownFile *file, uint32_t itemnr)
{
    wxString buffer;
    std::ostringstream internalbuffer;
    SetItemData(itemnr, (long) file);
    SetItem(itemnr, 1, CastItoXBytes(file->GetFileSize()));
    // added by InterCeptor (show filetype) 11.11.02:
    SetItem(itemnr, 2, GetFiletypeByName(wxString(file->GetFileName(), *wxConvCurrent)));
    //UAP
    if (DynPrefs::Get<bool>("auto-priority-share") && file->IsAutoUpPriority())
    {
        switch (file->GetUpPriority())
        {
        case PR_NORMAL:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIOAUTONORMAL));
                break;
            }
        case PR_HIGH:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIOAUTOHIGH));
                break;
            }
        case PR_VERYHIGH:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIOAUTORELEASE));
                break;
            }
        }
    }
    else
    {
        //endUAP
        switch (file->GetUpPriority())
        {
        case PR_VERYLOW:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIOVERYLOW));
                break;
            }
        case PR_LOW:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIOLOW));
                break;
            }
        case PR_NORMAL:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIONORMAL));
                break;
            }
        case PR_HIGH:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIOHIGH));
                break;
            }
        case PR_VERYHIGH:
            {
                SetItem(itemnr, 3, GetResString(IDS_PRIORELEASE));
                break;
            }
        }
    }
 /*if (file->GetPermissions() == PERM_NOONE)
 SetItemText(itemnr,4,"Hidden");
 else if (file->GetPermissions() == PERM_FRIENDS)
 SetItemText(itemnr,4,"Friends Only");
 else
    SetItemText(itemnr,4,"Public Shared");*/
    SetItem(itemnr, 4, GetResString(IDS_FSTATUS_PUBLIC));
    //	buffer[0] = 0;
    //	for (uint16_t i = 0;i != 16;i++) // hmm I wonder if there is a standard function for this
    //		sprintf(buffer,"%s%02X",buffer,file->GetFileHash()[i]);
    SetItem(itemnr, 5, EncodeBase16(file->GetFileHash(), 16));
    internalbuffer << file->statistic.GetRequests() << " (" << file->statistic.GetAllTimeRequests() << ")"; 
    buffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    SetItem(itemnr, 6, buffer);
    internalbuffer << file->statistic.GetAccepts() << " (" << file->statistic.GetAllTimeAccepts() << ")";
    buffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    SetItem(itemnr, 7, buffer);
    internalbuffer << CastItoXBytes(file->statistic.GetTransfered()).mb_str(*wxConvCurrent) << " (" << CastItoXBytes(file->statistic.GetAllTimeTransfered()).mb_str(*wxConvCurrent) << ")";
    buffer = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    internalbuffer.str("");
    SetItem(itemnr, 8, buffer);
}

void CSharedFilesCtrl::ShowFile(CKnownFile *file)
{
    ShowFile(file, GetItemCount());
}

void CSharedFilesCtrl::ShowFile(CKnownFile *file, uint32_t itemnr)
{
    //InsertItem(LVIF_TEXT|LVIF_PARAM,itemnr,file->GetFileName(),0,0,0,(LPARAM)file);
    int newitem = InsertItem(itemnr, wxString(file->GetFileName(), *wxConvCurrent));
    SetItemData(newitem, (long) file);
    // set background...
    wxODListItem myitem;
    myitem.m_itemId = newitem;
    myitem.SetBackgroundColour(SYSCOLOR(wxSYS_COLOUR_LISTBOX));
    SetItem(myitem);
    UpdateFile(file, itemnr);
    ShowFilesCount();
}

bool CSharedFilesCtrl::ProcessEvent(wxEvent &evt)
{
    if (evt.GetEventType() != wxEVT_COMMAND_MENU_SELECTED)
    return CMuleListCtrl::ProcessEvent(evt);
    wxCommandEvent &event = (wxCommandEvent &) evt;
    x::UINT selectedCount = this->GetSelectedItemCount();
    //GetSelectionMark();:
    int iSel = GetNextItem( - 1, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED);
    if (iSel != ( - 1))
    {
        CKnownFile *file = (CKnownFile *) GetItemData(iSel);
        switch (event.GetId())
        {
        case 123456789:
            {
                //theApp.xmuledlg->ircwnd.SetSendFileString(theApp.CreateED2kLink(file));
                cout << "todo: ircwnd" << endl;
                break;
            }
        case MP_GETHTMLED2KLINK:
            {
                if (selectedCount > 1)
                {
                    int i = iSel;
                    wxString str;
                    do
                    {
                        CKnownFile *file2 = (CKnownFile *) GetItemData(i);
                        str += theApp.CreateHTMLED2kLink(file2) + wxT("\n");
                    }
                    while ((i = GetNextItem(i, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED)) != - 1);
                    theApp.CopyTextToClipboard(str);
                    break;
                }
                theApp.CopyTextToClipboard(theApp.CreateHTMLED2kLink(file));
                break;
            }
        case MP_OPEN:
            {
                std::ostringstream buffer;
                buffer << file->GetPath() << "/" << file->GetFileName();
                theApp.xmuledlg->AddLogLine(false, wxString(buffer.str().c_str(), *wxConvCurrent));
                //ShellOpenFile(buffer);
                cout << "todo: shellopenfile " << buffer << endl;
                break;
            }
            //For Comments
        case MP_CMT:
            {
                CCommentDialog dialog(this, file);
                //dialog.DoModal();
                dialog.ShowModal();
                break;
            }
        case MP_PRIOVERYLOW:
        case MP_PRIOLOW:
        case MP_PRIONORMAL:
        case MP_PRIOHIGH:
        case MP_PRIOVERYHIGH:
        case MP_PRIOAUTO:
            {
                //POSITION pos = this->GetFirstSelectedItemPosition();
                bool no_partfile_selected = false;
                long pos = GetNextItem( - 1, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED);
                while (pos != ( - 1))
                {
                    //this->GetNextSelectedItem(pos);:
                    int iSel = pos;
                    file = (CKnownFile *) this->GetItemData(iSel);
                    switch (event.GetId())
                    {
                    case MP_PRIOVERYLOW:
                        {
                            file->SetAutoUpPriority(false);
                            file->SetUpPriority(PR_VERYLOW);
                            SetItem(iSel, 3, GetResString(IDS_PRIOVERYLOW));
                            break;
                        }
                    case MP_PRIOLOW:
                        {
                            file->SetAutoUpPriority(false);
                            file->SetUpPriority(PR_LOW);
                            SetItem(iSel, 3, GetResString(IDS_PRIOLOW));
                            break;
                        }
                    case MP_PRIONORMAL:
                        {
                            file->SetAutoUpPriority(false);
                            file->SetUpPriority(PR_NORMAL);
                            SetItem(iSel, 3, GetResString(IDS_PRIONORMAL));
                            break;
                        }
                    case MP_PRIOHIGH:
                        {
                            file->SetAutoUpPriority(false);
                            file->SetUpPriority(PR_HIGH);
                            SetItem(iSel, 3, GetResString(IDS_PRIOHIGH));
                            break;
                        }
                    case MP_PRIOVERYHIGH:
                        {
                            file->SetAutoUpPriority(false);
                            file->SetUpPriority(PR_VERYHIGH);
                            SetItem(iSel, 3, GetResString(IDS_PRIORELEASE));
                            break;
                        }
                    case MP_PRIOAUTO:
                        {
                            if (file->IsPartFile())
                            {
                                file->SetAutoUpPriority(true);
                                file->UpdateAutoUpPriority();
                                if (file->GetUpPriority() == PR_VERYHIGH)
                                SetItem(iSel, 3, GetResString(IDS_PRIOAUTORELEASE));
                                else if(file->GetUpPriority() == PR_HIGH)
                                SetItem(iSel, 3, GetResString(IDS_PRIOAUTOHIGH));
                                else if(file->GetUpPriority() == PR_NORMAL)
                                SetItem(iSel, 3, GetResString(IDS_PRIOAUTONORMAL));
                            }
                            else no_partfile_selected = true;
                        }
                    }
                    pos = GetNextItem(pos, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED);
                }
                break;
            }
        case MP_PERMNONE:
            {
                cout << "FIX: ei tue multi-select" << endl;
                if (((CPartFile *) file)->IsPartFile())
                //AfxMessageBox(GetResString(IDS_ERR_NOPRIMCHANGE));
                wxMessageBox(GetResString(IDS_ERR_NOPRIMCHANGE));
                else
                {
                    file->SetPermissions(PERM_NOONE);
                    SetItem(iSel, 4, GetResString(IDS_HIDDEN));
                }
                break;
            }
        case MP_PERMFRIENDS:
            {
                if (((CPartFile *) file)->IsPartFile())
                //AfxMessageBox(GetResString(IDS_ERR_NOPRIMCHANGE));
                wxMessageBox(GetResString(IDS_ERR_NOPRIMCHANGE));
                else
                {
                    file->SetPermissions(PERM_FRIENDS);
                    SetItem(iSel, 4, GetResString(IDS_FSTATUS_FRIENDSONLY));
                }
                break;
            }
        case MP_PERMALL:
            {
                file->SetPermissions(PERM_ALL);
                SetItem(iSel, 4, GetResString(IDS_FSTATUS_PUBLIC));
                break;
            }
        }
    }
    return CMuleListCtrl::ProcessEvent(evt);
}

//void CSharedFilesCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){
void CSharedFilesCtrl::OnColumnClick(wxODListEvent &evt)
{
    std::pair<int, bool> sort_info = GetSortInfo();
    int sortItem = sort_info.first;
    bool sortAscending;

    if (sortItem == evt.GetColumn())
    {
        sortAscending = !sort_info.second;
    }
    else
    {
        sortItem = evt.GetColumn();
        sortAscending = false;
    }

    SaveSortInfo(sortItem, sortAscending);

    // Ornis 4-way-sorting
    int adder = 0;
    if (evt.GetColumn() > 5 &&evt.GetColumn() < 9)
    {
        if (!sortAscending) sortstat[evt.GetColumn() - 6] =!sortstat[evt.GetColumn() - 6];
        adder = sortstat[evt.GetColumn() - 6] ? 0: 100;
    }

    SetSortArrow(sortItem, sortAscending);
    SortItems(SortProc, sortItem + adder + (sortAscending ? 0: 100));
}

int CSharedFilesCtrl::SortProc(long lParam1, long lParam2, long lParamSort)
{
    CKnownFile *item1 = (CKnownFile *) lParam1;
    CKnownFile *item2 = (CKnownFile *) lParam2;
    switch (lParamSort)
    {
        //filename asc:
    case 0:
        return item1->GetFileName().Cmp(item2->GetFileName());
        //filename desc:
    case 20:
        return item2->GetFileName().Cmp(item1->GetFileName());
        //filesize asc:
    case 1:
        return item1->GetFileSize() == item2->GetFileSize() ?0: (item1->GetFileSize() > item2->GetFileSize() ?1: - 1);
        //filesize desc:
    case 21:
        return item1->GetFileSize() == item2->GetFileSize() ?0: (item2->GetFileSize() > item1->GetFileSize() ?1: - 1);
        //filetype asc:
    case 2:
        return wxStricmp(GetFiletypeByName(wxString(item1->GetFileName(), *wxConvCurrent)), GetFiletypeByName(wxString(item2->GetFileName(), *wxConvCurrent)));
        //filetype desc:
    case 22:
        return wxStricmp(GetFiletypeByName(wxString(item2->GetFileName(), *wxConvCurrent)), GetFiletypeByName(wxString(item1->GetFileName(), *wxConvCurrent)));
        //prio asc:
    case 3:
        if (item1->GetUpPriority() == PR_VERYLOW)
        return 1;
        else if(item2->GetUpPriority() == PR_VERYLOW)
        return 0;
        else
        return item2->GetUpPriority() - item1->GetUpPriority();
        //prio desc:
    case 23:
        if (item1->GetUpPriority() == PR_VERYLOW)
        return 0;
        else if(item2->GetUpPriority() == PR_VERYLOW)
        return 1;
        else
        return item1->GetUpPriority() - item2->GetUpPriority();
        //permission asc:
    case 4:
        return item2->GetPermissions() - item1->GetPermissions();
        //permission desc:
    case 24:
        return item1->GetPermissions() - item2->GetPermissions();
        //fileID asc:
    case 5:
        return strcasecmp((char *) item1->GetFileHash(), (char *) item2->GetFileHash());
        //fileID desc:
    case 25:
        return strcasecmp((char *) item2->GetFileHash(), (char *) item1->GetFileHash());
        //requests asc:
    case 6:
        return item1->statistic.GetRequests() - item2->statistic.GetRequests();
        //requests desc:
    case 26:
        return item2->statistic.GetRequests() - item1->statistic.GetRequests();
        //acc requests asc:
    case 7:
        return item1->statistic.GetAccepts() - item2->statistic.GetAccepts();
        //acc requests desc:
    case 27:
        return item2->statistic.GetAccepts() - item1->statistic.GetAccepts();
        //all transferred asc:
    case 8:
        return item1->statistic.GetTransfered() == item2->statistic.GetTransfered() ?0: (item1->statistic.GetTransfered() > item2->statistic.GetTransfered() ?1: - 1);
        //all transferred desc:
    case 28:
        return item1->statistic.GetTransfered() == item2->statistic.GetTransfered() ?0: (item2->statistic.GetTransfered() > item1->statistic.GetTransfered() ?1: - 1);
        //folder asc:
    case 10:
        return item1->GetPath().Cmp(item2->GetPath());
        //folder desc:
    case 30:
        return item2->GetPath().Cmp(item1->GetPath());
        //all requests asc:
    case 106:
        return item1->statistic.GetAllTimeRequests() - item2->statistic.GetAllTimeRequests();
        //all requests desc:
    case 126:
        return item2->statistic.GetAllTimeRequests() - item1->statistic.GetAllTimeRequests();
        //all acc requests asc:
    case 107:
        return item1->statistic.GetAllTimeAccepts() - item2->statistic.GetAllTimeAccepts();
        //all acc requests desc:
    case 127:
        return item2->statistic.GetAllTimeAccepts() - item1->statistic.GetAllTimeAccepts();
        //all transferred asc:
    case 108:
        return item1->statistic.GetAllTimeTransfered() == item2->statistic.GetAllTimeTransfered() ?0: (item1->statistic.GetAllTimeTransfered() > item2->statistic.GetAllTimeTransfered() ?1: - 1);
        //all transferred desc:
    case 128:
        return item1->statistic.GetAllTimeTransfered() == item2->statistic.GetAllTimeTransfered() ?0: (item2->statistic.GetAllTimeTransfered() > item1->statistic.GetAllTimeTransfered() ?1: - 1);
    default:
        return 0;
    }
}

void CSharedFilesCtrl::UpdateItem(CKnownFile *toupdate)
{
    //LVFINDINFO find;
    //find.flags = LVFI_PARAM;
    //find.lParam = (LPARAM)toupdate;
    int16_t result = FindItem( - 1, (long) toupdate);
    if (result != - 1)
    {
        UpdateFile(toupdate, result);
        //Update(result) ;   // Added by Tarod to real time refresh - DonGato - 11/11/2002
        theApp.xmuledlg->sharedfileswnd->Check4StatUpdate(toupdate);
    }
}

void CSharedFilesCtrl::ShowFilesCount()
{
    std::ostringstream internalbuffer;
    internalbuffer << "Shared Files (" << GetItemCount() << ")";
    wxString fmtstr = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
    wxStaticCast(FindWindowByName(wxT("sharedFilesLabel")), wxStaticText)->SetLabel(fmtstr);
}

void CSharedFilesCtrl::OnDrawItem(int item, wxDC *dc, const wxRect &rect, const wxRect &rectHL, bool highlighted)
{
    CKnownFile *file = (CKnownFile *) GetItemData(item);
    assert(file != NULL);
    if (highlighted)
    {
        wxColour newcol;
        wxBrush hilBrush;
        if (GetFocus())
        {
            wxColour col = wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT);
            newcol = wxColour(G_BLEND(col.Red(), 125),
            G_BLEND(col.Green(), 125),
            G_BLEND(col.Blue(), 125));
            hilBrush = wxBrush(newcol, wxSOLID);
            dc->SetBackground(hilBrush);
            dc->SetTextForeground(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHTTEXT));
        }
        else
        {
            wxColour col = wxSystemSettings::GetColour(wxSYS_COLOUR_BTNSHADOW);
            newcol = wxColour(G_BLEND(col.Red(), 125),
            G_BLEND(col.Green(), 125),
            G_BLEND(col.Blue(), 125));
            hilBrush = wxBrush(newcol, wxSOLID);
            dc->SetBackground(hilBrush);
            dc->SetTextForeground(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHTTEXT));
        }
        newcol = wxColour(((int) newcol.Red() *65) /100,
        ((int) newcol.Green() *65) /100,
        ((int) newcol.Blue() *65) /100);
        dc->SetPen(wxPen(newcol, 1, wxSOLID));
    }
    else
    {
        dc->SetBackground( * (wxTheBrushList->FindOrCreateBrush(wxSystemSettings::GetColour(wxSYS_COLOUR_LISTBOX), wxSOLID)));
        dc->SetTextForeground(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWTEXT));
        dc->SetPen( *wxTRANSPARENT_PEN);
    }
    dc->SetBrush(dc->GetBackground());
    dc->DrawRectangle(rectHL);
    dc->SetPen( *wxTRANSPARENT_PEN);
    wxRect columnRect = rect;
#define SPARE_PIXELS_HORZ	4
#define SPARE_PIXELS_VERT_TEXT	3
    columnRect.SetLeft(columnRect.GetLeft() + SPARE_PIXELS_HORZ);
    columnRect.SetWidth(columnRect.GetWidth() - 2 *SPARE_PIXELS_HORZ);
    for (int iColumn = 0 ; iColumn < GetColumnCount() ; iColumn++)
    {
        wxODListItem columnItem;
        GetColumn(iColumn, columnItem);
        int width = columnItem.GetWidth();
        columnRect.SetWidth(width - 2 *SPARE_PIXELS_HORZ);
        wxDCClipper clipper( *dc, columnRect);
        switch (iColumn)
        {
        case 9:
            file->DrawShareStatusBar(dc, columnRect, false, (DynPrefs::Get<long>("progress-bar-style") == 0));
            break;
        default:
            columnItem.m_col = iColumn;
            columnItem.m_itemId = item;
            GetItem(columnItem);
            dc->DrawText(columnItem.m_text, columnRect.GetLeft(), columnRect.GetTop() + SPARE_PIXELS_VERT_TEXT);
            break;
        }
        columnRect.SetLeft(columnRect.GetLeft() + width);
    }
}

void CSharedFilesCtrl::clickGetED2KLink(wxCommandEvent& WXUNUSED(event))
{
    unsigned int selectedCount = GetSelectedItemCount();
    int selected = GetNextItem(-1, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED);
    wxString str;

    if (selected == -1) { return; }

    str = theApp.CreateED2kLink(reinterpret_cast<CKnownFile *>(this->GetItemData(selected)));
    
    if (selectedCount > 1)
    {
        do
        {
            CKnownFile* file2 = reinterpret_cast<CKnownFile *>(this->GetItemData(selected));
            str += theApp.CreateED2kLink(file2) + wxT("\n");
        } while ((selected = this->GetNextItem(selected, wxODLIST_NEXT_ALL, wxODLIST_STATE_SELECTED)) != - 1);

    }

    theApp.CopyTextToClipboard(str);
}
