// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA


#ifndef _SHAREDFILESWND_H
#define _SHAREDFILESWND_H

#include "KnownFile.h"                 // CKnownFile
#include "SharedFilesCtrl.h"           // CSharedFilesCtrl

#include <wx/gauge.h>                  // wxGauge
#include <wx/panel.h>                  // wxPanel
#include <wx/statbmp.h>                // wxStaticBitmap

class CSharedFilesWnd : public wxPanel //CResizableDialog
{
  //DECLARE_DYNAMIC(CSharedFilesWnd)

public:
	CSharedFilesWnd(wxWindow* pParent = NULL);   // standard constructor
	virtual ~CSharedFilesWnd();
	void Localize();
	void Check4StatUpdate(CKnownFile* file);
// Dialog Data
	CSharedFilesCtrl* sharedfilesctrl;

protected:
	//virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//virtual bool OnInitDialog();
	//virtual bool	PreTranslateMessage(MSG* pMsg);
	//DECLARE_MESSAGE_MAP()
	DECLARE_EVENT_TABLE()

	void OnLvnItemActivateSflist(wxODListEvent& evt);
	void OnBnClickedReloadsharedfiles(wxCommandEvent& event);
	//afx_msg void OnLvnItemActivateSflist(NMHDR *pNMHDR, LRESULT *pResult);
	//afx_msg void OnNMClickSflist(NMHDR *pNMHDR, LRESULT *pResult);
private:
	void ShowDetails(CKnownFile* cur_file);

	wxGauge* pop_bar;
	wxGauge* pop_baraccept;
	wxGauge* pop_bartrans;

	wxFont bold;
	unsigned char shownFileHash[16];
	wxStaticBitmap m_ctrlStatisticsFrm;
};
#endif
