// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _UPLOADQUEUE_H
#define _UPLOADQUEUE_H

#include "mfc.h"                            // Needed for POSITION
#include <stdint.h>                         // Needed for uint32_t

class CPreferences;
class CUpDownClient;
class wxTimer;

// Helper class holding a copy of a filehash
// The CCKey class is similiar but not useable here.
class CFileHash {
public:
    CFileHash();
    CFileHash(const unsigned char* k);
    CFileHash(const CFileHash& s);
    friend bool operator==(const CFileHash& h1, const CFileHash& h2);
    operator const unsigned char*() const;

private:
    unsigned char m_hash[16];
};

class CUploadQueue
{
public:
	CUploadQueue(CPreferences* in_prefs);
	~CUploadQueue();
	void	Process();
	void	AddClientToQueue(CUpDownClient* client,bool bIgnoreTimelimit = false);
	bool	RemoveFromUploadQueue(CUpDownClient* client,bool updatewindow = true);
	bool	RemoveFromWaitingQueue(CUpDownClient* client,bool updatewindow = true);
	bool	IsOnUploadQueue(CUpDownClient* client)	{return GetWaitingClient(client);}
	bool	IsDownloading(CUpDownClient* client)	{return GetDownloadingClient(client);}
	uint32_t	GetDatarate()							{return datarate;}
	bool	CheckForTimeOver(CUpDownClient* client);
	int		GetWaitingUserCount()					{return waitinglist.GetCount();}
	int		GetUploadQueueLength()					{return uploadinglist.GetCount();}
        POSITION GetFirstFromUploadList()                               {return
uploadinglist.GetHeadPosition();}
        CUpDownClient* GetNextFromUploadList(POSITION &curpos)  {return uploadinglist.GetNext(curpos);}
        CUpDownClient* GetQueueClientAt(POSITION &curpos)       {return uploadinglist.GetAt(curpos);}
 
        POSITION GetFirstFromWaitingList()                              {return
waitinglist.GetHeadPosition();}
        CUpDownClient* GetNextFromWaitingList(POSITION &curpos) {return waitinglist.GetNext(curpos);}
        CUpDownClient* GetWaitClientAt(POSITION &curpos)        {return waitinglist.GetAt(curpos);}
 

	void	UpdateBanCount();
	CUpDownClient*	GetWaitingClientByIP(uint32_t dwIP);
	CUpDownClient*	GetNextClient(CUpDownClient* update);

	
	void	DeleteAll();
	uint16_t	GetWaitingPosition(CUpDownClient* client);
	void	SetBanCount(uint32_t in_count)			{bannedcount = in_count;}
	uint32_t	GetBanCount()							{return bannedcount;}
	uint32_t	GetSuccessfullUpCount()					{return successfullupcount;}
	uint32_t	GetFailedUpCount()						{return failedupcount;}
	uint32_t	GetAverageUpTime();
	void	FindSourcesForFileById(CTypedPtrList<CPtrList, CUpDownClient*>* srclist, unsigned char* filehash);
	void	AddUpDataOverheadSourceExchange(uint32_t data)	{ m_nUpDataRateMSOverhead += data;
															  m_nUpDataOverheadSourceExchange += data;
															  m_nUpDataOverheadSourceExchangePackets++;}
	void	AddUpDataOverheadFileRequest(uint32_t data)		{ m_nUpDataRateMSOverhead += data;
															  m_nUpDataOverheadFileRequest += data;
															  m_nUpDataOverheadFileRequestPackets++;}
	void	AddUpDataOverheadServer(uint32_t data)	{ m_nUpDataRateMSOverhead += data;
															  m_nUpDataOverheadServer += data;
															  m_nUpDataOverheadServerPackets++;}

	void	AddUpDataOverheadOther(uint32_t data)				{ m_nUpDataRateMSOverhead += data;
															  m_nUpDataOverheadOther += data;
															  m_nUpDataOverheadOtherPackets++;}
	uint32_t	GetUpDatarateOverhead()						{return m_nUpDatarateOverhead;}
	uint64_t	GetUpDataOverheadSourceExchange()			{return m_nUpDataOverheadSourceExchange;}
	uint64_t	GetUpDataOverheadFileRequest()				{return m_nUpDataOverheadFileRequest;}
	uint64_t	GetUpDataOverheadServer()					{return m_nUpDataOverheadServer;}
	uint64_t	GetUpDataOverheadOther()					{return m_nUpDataOverheadOther;}
	uint64_t	GetUpDataOverheadSourceExchangePackets()	{return m_nUpDataOverheadSourceExchangePackets;}
	uint64_t	GetUpDataOverheadFileRequestPackets()		{return m_nUpDataOverheadFileRequestPackets;}
	uint64_t	GetUpDataOverheadServerPackets()			{return m_nUpDataOverheadServerPackets;}
	uint64_t	GetUpDataOverheadOtherPackets()				{return m_nUpDataOverheadOtherPackets;}
	void	CompUpDatarateOverhead();
	void	SuspendUpload( const CFileHash& );
	void	ResumeUpload( const CFileHash& );
protected:
	void	RemoveFromWaitingQueue(POSITION pos, bool updatewindow);
	POSITION	GetWaitingClient(CUpDownClient* client);
//	POSITION	GetWaitingClientByID(CUpDownClient* client);
	POSITION	GetDownloadingClient(CUpDownClient* client);
	bool		AcceptNewClient();
	void		AddUpNextClient(CUpDownClient* directadd = 0);
private:
	CList<int,int> avarage_dr_list;
	CTypedPtrList<CPtrList, CUpDownClient*> waitinglist;
	CTypedPtrList<CPtrList, CUpDownClient*> uploadinglist;
	CList<CFileHash, const CFileHash&> suspended_uploads_list;  //list for suspended uploads
	uint32_t	datarate;   //datarate 
	uint32_t	dataratems;	// datarate last 100ms
	uint32_t	datarateave; //datarage average (since progstart) *unused*
	int32_t	estadatarate; // esta. max datarate	
	CPreferences* app_prefs;
	wxTimer* h_timer;
	uint32_t	bannedcount;
	uint32_t	successfullupcount;
	uint32_t	failedupcount;
	uint32_t	totaluploadtime;
	uint32_t	m_nLastStartUpload;
	uint32_t	m_nUpDatarateOverhead;
	uint32_t	m_nUpDataRateMSOverhead;
	uint64_t	m_nUpDataOverheadSourceExchange;
	uint64_t	m_nUpDataOverheadFileRequest;
	uint64_t	m_nUpDataOverheadServer;
	uint64_t	m_nUpDataOverheadOther;
	uint64_t	m_nUpDataOverheadSourceExchangePackets;
	uint64_t	m_nUpDataOverheadFileRequestPackets;
	uint64_t	m_nUpDataOverheadServerPackets;
	uint64_t	m_nUpDataOverheadOtherPackets;
	uint32_t	m_nSumForAvgDataRate;
	CList<int,int>	m_AvarageUDRO_list;

};

#endif
