// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "xmule.h"
#	include "ClientList.h"
#endif

bool CClientList::VerifyUpload(uint32_t clientip, uint16_t port)
{
    CUpDownClient *tocheck = FindClientByIP(clientip, port);
    if (tocheck && ((tocheck->GetDownloadState() == DS_DOWNLOADING &&tocheck->GetDatarate() > 1000) || (tocheck->GetTransferedDown() > 400000)))
    return true;
    return false;
}

CUpDownClient *CClientList::VUGetRandomClient()
{
    CTypedPtrList < CPtrList, CUpDownClient *> templist;
    for (POSITION pos = list.GetHeadPosition() ; pos != 0 ; list.GetNext(pos))
    {
        CUpDownClient *cur_client = list.GetAt(pos);
        if (cur_client->socket &&cur_client->socket->IsConnected() &&cur_client->GetMuleVersion() >= 0x20 && (cur_client->GetTransferedUp() > 400000))
        {
            templist.AddTail(cur_client);
        }
    }
    if (templist.IsEmpty())
    return 0;
    uint16_t randomness = (uint16_t) ROUND(((float) rand() /RAND_MAX) * (templist.GetCount() - 1));
    return templist.GetAt(templist.FindIndex(randomness));
}

