// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#include <gtk/gtk.h>
#include <gtk/gtkprivate.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>

#include "gtk2-funcs.h"

extern guint32 gtk2_get_current_event_time (void);

guint32
gtk2_get_current_event_time (void)
{
	GdkEvent *ev = gtk_get_current_event();
	if ( ev ) {
		guint32 result;
		result = gdk_event_get_time(ev);
		gdk_event_free(ev);
		return result;
	} else {
		return GDK_CURRENT_TIME;
	}

}

