/////////////////////////////////////////////////////////////////////////////
// Name:        wx/generic/listctrl.h
// Purpose:     Generic list control
// Author:      Robert Roebling
// Created:     01/02/97
// Id:
// Copyright:   (c) 1998 Robert Roebling, Julian Smart and Markus Holzem
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _LISTCTRL_GEN_H_
#define _LISTCTRL_GEN_H_

#include <wx/defs.h>
#include <wx/object.h>
#include <wx/control.h>
#include <wx/timer.h>
#include <wx/dcclient.h>
#include <wx/scrolwin.h>
#include <wx/settings.h>
#include <wx/hashmap.h>
#include <wx/wxchar.h>
#include <wx/imaglist.h>

#include "listbase.h"

#if wxUSE_DRAG_AND_DROP
class wxDropTarget;
#endif

//-----------------------------------------------------------------------------
// classes
//-----------------------------------------------------------------------------

class wxODListItem;
class wxODListEvent;
class wxODListCtrl;

WX_DECLARE_HASH_MAP(long, void*, wxIntegerHash, wxIntegerEqual, ItemDataMap);

//-----------------------------------------------------------------------------
// internal classes
//-----------------------------------------------------------------------------

class wxODListHeaderData;
class wxODListItemData;
class wxODListLineData;

class wxODListHeaderWindow;
class wxODListMainWindow;

class wxODListRenameTimer;
class wxODListTextCtrl;

//-----------------------------------------------------------------------------
// wxODListCtrl
//-----------------------------------------------------------------------------

class wxODGenericListCtrl: public wxControl
{
public:
    wxODGenericListCtrl();
    wxODGenericListCtrl( wxWindow *parent,
                wxWindowID id = -1,
                const wxPoint &pos = wxDefaultPosition,
                const wxSize &size = wxDefaultSize,
                long style = wxODLC_ICON,
                const wxValidator& validator = wxDefaultValidator,
                const wxString &name = wxT("listctrl") )
    {
        Create(parent, id, pos, size, style, validator, name);
    }
    ~wxODGenericListCtrl();

    bool Create( wxWindow *parent,
                 wxWindowID id = -1,
                 const wxPoint &pos = wxDefaultPosition,
                 const wxSize &size = wxDefaultSize,
                 long style = wxODLC_ICON,
                 const wxValidator& validator = wxDefaultValidator,
                 const wxString &name = wxT("listctrl") );

    bool GetColumn( int col, wxODListItem& item ) const;
    bool SetColumn( int col, wxODListItem& item );
    int GetColumnWidth( int col ) const;
    bool SetColumnWidth( int col, int width);
    int GetCountPerPage() const; // not the same in wxGLC as in Windows, I think

    void GetVisibleLines(long* first,long* last);

    bool GetItem( wxODListItem& info ) const;
    bool SetItem( wxODListItem& info ) ;
    long SetItem( long index, int col, const wxString& label, int imageId = -1 );
    int  GetItemState( long item, long stateMask ) const;
    bool SetItemState( long item, long state, long stateMask);
    bool SetItemImage( long item, int image, int selImage);
    wxString GetItemText( long item ) const;
    void SetItemText( long item, const wxString& str );
    long GetItemData( long item ) const;
    bool SetItemData( long item, long data );
    bool GetItemRect( long item, wxRect& rect, int code = wxODLIST_RECT_BOUNDS ) const;
    bool GetItemPosition( long item, wxPoint& pos ) const;
    bool SetItemPosition( long item, const wxPoint& pos ); // not supported in wxGLC
    int GetItemCount() const;
    int GetColumnCount() const;
    void SetItemSpacing( int spacing, bool isSmall = FALSE );
    int GetItemSpacing( bool isSmall ) const;
    void SetItemTextColour( long item, const wxColour& col);
    wxColour GetItemTextColour( long item ) const;
    void SetItemBackgroundColour( long item, const wxColour &col);
    wxColour GetItemBackgroundColour( long item ) const;
    int GetSelectedItemCount() const;
    wxColour GetTextColour() const;
    void SetTextColour(const wxColour& col);
    long GetTopItem() const;
    void SetSortArrow(int col, int mode);

    void SetSingleStyle( long style, bool add = TRUE ) ;
    void SetWindowStyleFlag( long style );
    void RecreateWindow() {}
    long GetNextItem( long item, int geometry = wxODLIST_NEXT_ALL, int state = wxODLIST_STATE_DONTCARE ) const;
    wxImageList *GetImageList( int which ) const;
    void SetImageList( wxImageList *imageList, int which );
    void AssignImageList( wxImageList *imageList, int which );
    bool Arrange( int flag = wxODLIST_ALIGN_DEFAULT ); // always wxODLIST_ALIGN_LEFT in wxGLC

    void ClearAll();
    bool DeleteItem( long item );
    bool DeleteAllItems();
    bool DeleteAllColumns();
    bool DeleteColumn( int col );

    void SetItemCount(long count);

    void EditLabel( long item ) { Edit(item); }
    void Edit( long item );

    bool EnsureVisible( long item );
    long FindItem( long start, const wxString& str, bool partial = FALSE );
    long FindItem( long start, long data );
    long FindItem( long start, const wxPoint& pt, int direction ); // not supported in wxGLC
    long HitTest( const wxPoint& point, int& flags);
    long InsertItem(wxODListItem& info);
    long InsertItem( long index, const wxString& label );
    long InsertItem( long index, int imageIndex );
    long InsertItem( long index, const wxString& label, int imageIndex );
    long InsertColumn( long col, wxODListItem& info );
    long InsertColumn( long col, const wxString& heading, int format = wxODLIST_FORMAT_LEFT,
      int width = -1 );
    bool ScrollList( int dx, int dy );
    bool SortItems( wxODListCtrlCompare fn, long data );
    bool Update( long item );

    // returns true if it is a virtual list control
    bool IsVirtual() const { return (GetWindowStyle() & wxODLC_VIRTUAL) != 0; }

    // refresh items selectively (only useful for virtual list controls)
    void RefreshItem(long item);
    void RefreshItems(long itemFrom, long itemTo);

    // implementation only from now on
    // -------------------------------

    void OnIdle( wxIdleEvent &event );
    void OnSize( wxSizeEvent &event );

    // We have to hand down a few functions

    virtual void Freeze();
    virtual void Thaw();

    virtual void OnDrawItem(int item,wxDC* dc,const wxRect& rect,const wxRect& rectHL,bool highlighted);

    virtual bool SetBackgroundColour( const wxColour &colour );
    virtual bool SetForegroundColour( const wxColour &colour );
    virtual wxColour GetBackgroundColour() const;
    virtual wxColour GetForegroundColour() const;
    virtual bool SetFont( const wxFont &font );
    virtual bool SetCursor( const wxCursor &cursor );

#if wxUSE_DRAG_AND_DROP
    virtual void SetDropTarget( wxDropTarget *dropTarget );
    virtual wxDropTarget *GetDropTarget() const;
#endif

    virtual bool DoPopupMenu( wxMenu *menu, int x, int y );

    virtual void SetFocus();
    virtual bool GetFocus();

    // implementation
    // --------------

    wxImageList         *m_imageListNormal;
    wxImageList         *m_imageListSmall;
    wxImageList         *m_imageListState;  // what's that ?
    bool                 m_ownsImageListNormal,
                         m_ownsImageListSmall,
                         m_ownsImageListState;
    wxODListHeaderWindow  *m_headerWin;
    wxODListMainWindow    *m_mainWin;

protected:
    // return the text for the given column of the given item
    virtual wxString OnGetItemText(long item, long column) const;

    // return the icon for the given item
    virtual int OnGetItemImage(long item) const;

    // return the attribute for the item (may return NULL if none)
    virtual wxODListItemAttr *OnGetItemAttr(long item) const;

    // it calls our OnGetXXX() functions
    friend class wxODListMainWindow;

private:
    // Virtual function hiding supression
    virtual void Update() { wxWindow::Update(); }

    // create the header window
    void CreateHeaderWindow();

    // reposition the header and the main window in the report view depending
    // on whether it should be shown or not
    void ResizeReportView(bool showHeader);

    DECLARE_EVENT_TABLE()
    DECLARE_DYNAMIC_CLASS(wxODGenericListCtrl);
};

class wxODListCtrl: public wxODGenericListCtrl
{
    DECLARE_DYNAMIC_CLASS(wxODListCtrl)

public:
    wxODListCtrl() {}

    wxODListCtrl(wxWindow *parent, wxWindowID id = -1,
               const wxPoint& pos = wxDefaultPosition,
               const wxSize& size = wxDefaultSize,
               long style = wxODLC_ICON,
               const wxValidator &validator = wxDefaultValidator,
               const wxString &name = wxT("listctrl") )
    : wxODGenericListCtrl(parent, id, pos, size, style, validator, name)
    { }
};

#endif // _LISTCTRL_GEN_H_
