// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _MFC_H_
#define _MFC_H_

// Wrappers for required MFC classes. Makes life a bit less annoying.

#include <vector>                           // std::vector

typedef void* POSITION;

//
// CList Class
//

template < class TYPE, class ARG_TYPE >
class CList
{
public:
    CList(int none = 0)
    {
        internalList = NULL;
        tail = NULL;
        count = 0;
    }
    // You really want to DELETE the list too!
    ~CList()
    {
        RemoveAll();
    };
    int GetCount() const
    {
        return count;
        //g_list_length(internalList);
    }
    ;
    int GetSize() const
    {
        return count;
        //g_list_length(internalList);
    }
    ;
    bool IsEmpty() const
    {
        return count == 0;
        //g_list_length(internalList)==0;
    }
    ;
    TYPE &GetHead()
    {
        if (internalList)
        {
            return internalList->data;
        }
        else
        {
            printf("1DO NOT CALL WITH EMPTY LIST\n");
            exit(1);
        }
    }
    TYPE GetHead() const
    {
        if (internalList)
        {
            return internalList->data;
        }
        else
        {
            return(TYPE) 0;
        }
    }
    TYPE &GetTail()
    {
        if (tail)
        {
            return tail->data;
        }
        else
        {
            printf("DONT CALL WITH EMPTY LIST\n");
            exit(1);
        }
    }
    TYPE GetTail() const
    {
        if (tail)
        {
            return tail->data;
        }
        else
        {
            return(TYPE) 0;
        }
    }
    TYPE RemoveHead()
    {
        if (internalList)
        {
            MYNODE *old = internalList;
            TYPE oldvalue = old->data;
            // advance head
            internalList = internalList->next;
            // if not null, then there are still items in the list
            if (internalList)
            internalList->prev = NULL;
            // and this is the head
            else
            tail = NULL;
            // otherwise.. no more list and tail
            freeNode(old);
            count--;
            return oldvalue;
        }
        // otherwise we are iterating on a empty list..
        return(TYPE) 0;
    }
    TYPE RemoveTail()
    {
        if (tail)
        {
            MYNODE* old = tail;
            TYPE olddata = tail->data;
            // move tail to previous node
            tail = tail->prev;
            // is there list anymore?
            if (tail)
            tail->next = NULL;
            // yes. this is the tail
            else
            internalList = NULL;
            // no. list has vanished
            freeNode(tail);
            count--;
            return olddata;
        }
        // iterating on an empty list
        return(TYPE) 0;
    }
    POSITION AddHead(ARG_TYPE uusi)
    {
        MYNODE *newnode = newNode(uusi);
        // we are adding to head!
        newnode->next = internalList;
        if (internalList)
        internalList->prev = newnode;
        else
        tail = newnode;
        internalList = newnode;
        count++;
        // return position to head
        return(POSITION) internalList;
    }
    POSITION AddTail(ARG_TYPE uusi)
    {
        MYNODE *newnode = newNode(uusi);
        // and to the tail
        newnode->prev = tail;
        if (tail)
        tail->next = newnode;
        else
        internalList = newnode;
        tail = newnode;
        count++;
        return(POSITION) tail;
    }
    POSITION Append(ARG_TYPE uusi)
    {
        // addtail
        return AddTail(uusi);
    }
    void RemoveAll()
    {
        MYNODE *first = internalList;
        while (first)
        {
            MYNODE *n = first->next;
            freeNode(first);
            first = n;
        }
        internalList = tail = NULL;
        count = 0;
    }
    POSITION GetHeadPosition() const
    {
        return(POSITION) internalList;
    }
    POSITION GetTailPosition() const
    {
        return(POSITION) tail;
    }
    TYPE &GetNext(POSITION &pos)
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            TYPE &data = n->data;
            n = n->next;
            pos = (POSITION) n;
            return data;
        }
        else
        {
            printf("2DO NOT CALL WITH EMPTY LIST!\n");
            exit(1);
        }
    }
    TYPE GetNext(POSITION &pos) const
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            TYPE data = n->data;
            n = n->next;
            pos = (POSITION) n;
            return data;
        }
        else
        {
            return(TYPE) 0;
        }
    }
    TYPE &GetPrev(POSITION &pos)
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            TYPE &data = n->data;
            n = n->prev;
            pos = (POSITION) n;
            return data;
        }
        else
        {
            printf("3DO NOT CALL WITH EMPTY LIST\n");
            exit(1);
        }
    }
    TYPE GetPrev(POSITION &pos) const
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            TYPE data = n->data;
            n = n->prev;
            pos = (POSITION) n;
            return data;
        }
        else
        {
            return(TYPE) 0;
        }
    }
    TYPE &GetAt(POSITION pos)
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            return n->data;
        }
        else
        {
            printf("4DO NOT CALL WITH EMPTY LIST\n");
            exit(1);
        }
    }
    TYPE GetAt(POSITION pos) const
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            return n->data;
        }
        return(TYPE) 0;
    }
    void RemoveAt(POSITION pos)
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            // are we removing the head?
            if (internalList == n)
            {
                // yes
                internalList = n->next;
            }
            else
            {
                // no
                n->prev->next = n->next;
            }
            // is it tail too?
            if (tail == n)
            {
                // yes
                tail = n->prev;
            }
            else
            {
                // no
                n->next->prev = n->prev;
            }
            freeNode(n);
            count--;
        }
    }
    void InsertAfter(POSITION pos, ARG_TYPE data)
    {
        MYNODE *n = (MYNODE *) pos;
        if (n)
        {
            MYNODE *newnode = newNode(data);
            newnode->prev = n;
            newnode->next = n->next;
            if (n->next)
            {
                n->next->prev = newnode;
            }
            else
            {
                // it's tail
                tail = newnode;
            }
            n->next = newnode;
            // increase count here. not after addtail()
            count++;
        }
        else
        {
            // just append
            pos = AddTail(data);
        }
    }
    POSITION Find(ARG_TYPE searchValue, POSITION startAfter = NULL) const
    {
        MYNODE *n = internalList;
        if (startAfter) n = ((MYNODE *) startAfter)->next;
        while (n)
        {
            if (n->data == searchValue)
            {
                return(POSITION) n;
            }
            n = n->next;
        }
        return(POSITION) 0;
    }
    POSITION FindIndex(int nIndex) const
    {
        MYNODE *n = internalList;
        for (int i = 0 ; i < nIndex ; i++)
        {
            if (n)
            {
                n = n->next;
            }
            else
            {
                // past the end
                return(POSITION) 0;
            }
        }
        return(POSITION) n;
    }
protected:
    struct MYNODE
    {
        struct MYNODE *next, *prev;
        TYPE data;
    };
    MYNODE* internalList;
    MYNODE* tail;
    int count;
    void freeNode(MYNODE *n)
    {
        delete n;
    }
    MYNODE* newNode(ARG_TYPE data)
    {
        MYNODE *n = new MYNODE;
        n->prev = n->next = NULL;
        n->data = data;
        return n;
    }
};

class CPtrList;

// typedptrlist is just an instance of ordinary list...
template < class BASE_CLASS, class TYPE >
class CTypedPtrList: public CList < TYPE, TYPE >
{
    public:
    CTypedPtrList(int nBlockSize = 0)
    {
    }
};

// Default hasher
template < class ARG_KEY >
unsigned int HashKey(ARG_KEY key)
{
    return((unsigned int) key);
}

// 
// CArray Class
//

template < class TYPE, class ARG_TYPE >
class CArray : private std::vector< ARG_TYPE >
{
public:
    typedef typename std::vector<TYPE>::iterator iterator;
    typedef std::vector<TYPE> inherited;

protected:
    iterator Index2It(int index)
    {
        iterator it = inherited::begin();
        it += index;
        return it;
    }

public:
    CArray()
    {
    }

    ~CArray()
    {
        inherited::clear();
    }

    int GetSize() const
    {
        return inherited::size();
    }

    int GetCount() const
    {
        return inherited::size();
    }

    int GetUpperBound() const
    {
        return inherited::size() - 1;
    }

    void SetSize(int newsiz, int growby = -1)
    {
        inherited::reserve(newsiz);
    }

    bool IsEmpty() const
    {
        return inherited::empty();
    }

    void RemoveAll()
    {
        inherited::clear();
    }

    void RemoveAt(int nIndex)
    {
        inherited::erase(Index2It(nIndex));
    }

    TYPE GetAt(int nIndex) const
    {
        return inherited::at(nIndex);
    }

    void SetAt(int nIndex, ARG_TYPE newElem)
    {
        this[nIndex] = newElem;
    }

    TYPE &ElementAt(int nIndex)
    {
        return (TYPE &)inherited::at(nIndex);
    }

    int Add(ARG_TYPE newElem)
    {
        inherited::push_back(newElem);
        return 0;
    }

    void InsertAt(int nIndex, ARG_TYPE newElem)
    {
        inherited::insert(Index2It(nIndex), newElem);
    }

    using inherited::operator[];
};

#endif // _MFC_H_
