// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

// Client to Server communication

#ifndef _SOCKETS_H
#define _SOCKETS_H

#include <map>                              // Needed for std::map
#include <stdint.h>                         // Needed for uint32_t
#include <wx/timer.h>                       // Needed for wxTimer

#define CS_FATALERROR	-5
#define CS_DISCONNECTED	-4
#define CS_SERVERDEAD	-3
#define	CS_ERROR		-2
#define CS_SERVERFULL	-1
#define	CS_NOTCONNECTED	0
#define	CS_CONNECTING	1
#define	CS_CONNECTED	2
#define	CS_WAITFORLOGIN	3
#define CS_RETRYCONNECTTIME  30 // seconds

class CPreferences;
class CServer;
class CServerList;
class CServerSocket;
class CUDPSocket;
class Packet;

class CServerConnect{
public:
	CServerConnect(CServerList* in_serverlist, CPreferences* in_prefs);
	~CServerConnect();
	void	ConnectionFailed(CServerSocket* sender);
	void	ConnectionEstablished(CServerSocket* sender);
	
	void	ConnectToAnyServer() {ConnectToAnyServer(0,true,true);}
	void	ConnectToAnyServer(uint32_t startAt,bool prioSort=false,bool isAuto=true);
	void	ConnectToServer(CServer* toconnect, bool multiconnect=false);
	void	StopConnectionTry();
	//static  x::VOID CALLBACK RetryConnectCallback(HWND hWnd, x::UINT nMsg, x::UINT nId, x::DWORD dwTime);

	void	CheckForTimeout();
	void	DestroySocket(CServerSocket* pSck);	// safe socket closure and destruction
	bool	SendPacket(Packet* packet,bool delpacket = true, CServerSocket* to = 0);
	bool	SendUDPPacket(Packet* packet,CServer* host, bool delpacket = false );
	bool	Disconnect();
	bool	IsConnecting()	{return connecting;}
	bool	IsConnected()	{return connected;}
	wxUint32	GetClientID()		{return clientid;}
	CServer*	GetCurrentServer();
	uint32_t	clientid;
	uint8_t	pendingConnects;
	bool	IsLowID()		{return (clientid < 16777216);}
	void	SetClientID(uint32_t newid);
	bool	IsLocalServer(uint32_t dwIP, uint16_t nPort);
	void	TryAnotherConnectionrequest();
	bool	IsSingleConnect()	{return singleconnecting;}
	void	InitLocalIP();
	wxUint32	GetLocalIP()		{ return m_nLocalIP; }

private:
	bool	connecting;
	bool	singleconnecting;
	bool	connected;
	int8_t	max_simcons;
	uint32_t lastStartAt;
	CPreferences*	app_prefs;
	CServerSocket*	connectedsocket;
	CServerList*	used_list;
	CUDPSocket*		udpsocket;
	CTypedPtrList<CPtrList,void*>		m_lstOpenSockets;	// list of currently opened sockets
	//UINT			m_idRetryTimer;
	wxTimer m_idRetryTimer;
	wxUint32 	m_nLocalIP;

	std::map<long int, CServerSocket *> connectionattempts;
// Added by sivka [Tarod: Tries after a LowID connection]
public: 
	void	ResetLowIDTries() {m_lowid_tries = 0;}
	int	GetLowIDTries() {return m_lowid_tries;}
	void	IncrementLowIDTries() {m_lowid_tries++;}
private:
	int	m_lowid_tries;
};
#endif
