// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "xmule.h"                          // Needed for this Interface's Prototype
#include <wx/toplevel.h>
#include "ChatWnd.h"                        // Needed for CChatWnd
#include "ClientCredits.h"                  // Needed for CClientCredits
#include "ClientList.h"                     // Needed for CClientList
#include "config.h"                         // Needed for HAVE_SYS_RESOURCE_H
#include "DownloadListCtrl.h"               // Needed for CDownloadListCtrl
#include "DownloadQueue.h"                  // Needed for CDownloadQueue
#include "ED2KLink.h"                       // Needed for CED2KLink
#include "FlowChart.h"                      // Needed for CFlowChart
#include "FriendList.h"                     // Needed for CFriendList
#include "IPFilter.h"                       // Needed for CIPFilter
#include "KnownFile.h"                      // Needed for CKnownFile
#include "KnownFileList.h"                  // Needed for CKnownFileList
#include "ldaemon.h"                        // Needed for CLDaemon
#include "ListenSocket.h"                   // Needed for CListenSocket
#include "muuli_wdr.h"                      // Needed for ID_FRIENDLIST
#include "NewFunctions.h"                   // Needed for MAP
#include "NewSockets.h"                     // Needed for NewSocket_Start
#include "otherfunctions.h"                 // Needed for CastItoXBytes
#include "Preferences.h"                    // CPreferences::List Settings
#include "PreferencesDlg.h"                 // Needed for CPreferencesDlg
#include "QueueListCtrl.h"                  // Needed for CQueueListCtrl
#include "server.h"                         // Needed for CServer
#include "ServerList.h"                     // Needed for CServerList
#include "ServerListCtrl.h"                 // Needed for CServerListCtrl
#include "ServerWnd.h"                      // Needed for CServerWnd
#include "SharedFileList.h"                 // Needed for CSharedFileList
#include "SharedFilesCtrl.h"                // Needed for CSharedFilesCtrl
#include "SharedFilesWnd.h"                 // Needed for CSharedFilesWnd
#include "sockets.h"                        // Needed for CServerConnect
#include "StatisticsDlg.h"                  // Needed for CStatisticsDlg
#include "TransferWnd.h"                    // Needed for CTransferWnd
#include "updownclient.h"                   // Needed for CUpDownClient
#include "UploadListCtrl.h"                 // Needed for CUploadListCtrl
#include "UploadQueue.h"                    // Needed for CUploadQueue
#include "xmuleDlg.h"                       // Needed for CxmuleDlg

#include <DynPrefs/DynPrefs.h>              // Needed for DynamicPreferences
#include <DynPrefs/DynPrefsCtrl.h>          // Needed for wxEVT_PREFS_CHANGED

#include <iostream>                         // Needed for std::cout
#include <sstream>
#include <iomanip>
#include <gtk/gtk.h>                        // Needed for GTK_WINDOW_TOPLEVEL

#include <wx/clipbrd.h>                     // Needed for wxTheClipboard
#include <wx/msgdlg.h>                      // Needed for wxMessageBox
#include <wx/splash.h>                      // Needed for wxSplashScreen

#include <wx/xrc/xmlres.h>                  // Needed for wxXmlResource

#include <unistd.h>                         // Needed for close

using std::left;
using std::setw;
using std::setprecision;
using std::cout;
using std::endl;

IMPLEMENT_APP(CxmuleApp)

void InitSplashXRC();

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifdef __GLIBC__
# define RLIMIT_RESOURCE __rlimit_resource
#else
# define RLIMIT_RESOURCE int
#endif

//MAP* listof_sourcesKF;

static void UnlimitResource(RLIMIT_RESOURCE resType)
{
#if defined(HAVE_GETRLIMIT) && defined(HAVE_SETRLIMIT)
    struct rlimit rl;
    getrlimit(resType, & rl);
    rl.rlim_cur = rl.rlim_max;
    setrlimit(resType, & rl);
#endif
}

static void SetResourceLimits()
{
#ifdef HAVE_SYS_RESOURCE_H
    UnlimitResource(RLIMIT_DATA);
    UnlimitResource(RLIMIT_FSIZE);
    UnlimitResource(RLIMIT_NOFILE);
    UnlimitResource(RLIMIT_RSS);
#endif
}

CxmuleApp::CxmuleApp()
{
}

CxmuleApp::~ CxmuleApp()
{
    listensocket->Destroy();
}

int CxmuleApp::OnExit()
{
    delete uploadqueue;
	glob_prefs->Save(5);
    cout << "xMule shutdown completed." << endl;
    return wxApp::OnExit();
}

extern void InitXmlResource();

bool CxmuleApp::OnInit()
{
//    mtrace();
    daemon = nowindow = false;
    for (int i = 1 ; i < argc ; i++)
    {
        if (strncmp(wxString(argv[i], *wxConvCurrent).mb_str(*wxConvCurrent), "--version", 7) == 0)
        {
            cout << PACKAGE << " version " << VERSION << endl;
            exit(0);
        }
        else if (strncmp(wxString(argv[i], *wxConvCurrent).mb_str(*wxConvCurrent), "--daemon", 8) == 0)
        {
            cout << "Starting without windows" << endl;
            daemon = true;
        }
    }
//    MapData_Init(listof_sourcesKF);
    wxHandleFatalExceptions(true);
    SetResourceLimits();
    // for resources
    wxXmlResource::Get()->InitAllHandlers();
    InitXmlResource();
    cout << "Initialising xMule" << endl;
    close(0);
    SetVendorName(wxT("TikuWarez"));

    // Do NOT change this string to xMule nor anything else, it WILL fuck you up.
    SetAppName(wxT("eMule"));
    m_locale.Init(wxLANGUAGE_DEFAULT);
    m_locale.AddCatalogLookupPathPrefix(wxT(LOCALEDIR));
    m_locale.AddCatalog(wxT(PACKAGE));

    // Madcat - Check if prefs can be found at ~/.lmule and rename as neccesery.
    wxString OldPrefDir = wxString(getenv("HOME"), *wxConvCurrent) + wxT("/.lmule");
    wxString NewPrefDir = wxString(getenv("HOME"), *wxConvCurrent) + wxT("/.xMule");

    if (wxDirExists(OldPrefDir) && !wxDirExists(NewPrefDir))
    {
        cout << "Found old settings, moving to new dir." << endl;
        wxRenameFile(OldPrefDir, NewPrefDir);
    }

    if (!wxDirExists(NewPrefDir))
    {
        wxMkdir(NewPrefDir, 0777);
    }

    if (!wxDirExists(NewPrefDir + wxT("/Incoming")))
    {
        wxMkdir(NewPrefDir + wxT("/Incoming"), 0777);
    }

    if (!wxDirExists(NewPrefDir + wxT("/Temp")))
    {
        wxMkdir(NewPrefDir + wxT("/Temp"), 0777);
    }

    wxString filename = NewPrefDir + wxT("/server.met");

    if (!wxFileExists(filename))
    {
        wxFile metfile(filename, wxFile::write_excl);

        if (metfile.IsOpened())
        {
            metfile.Close();
        }
    }

    // Create Debug Variable
    DynPrefs::Add("Debug", true);
    glob_prefs = new CPreferences();

    std::ostringstream internalbuffer;
    internalbuffer << PACKAGE << " v" << VERSION;
    CxmuleDlg* dlg = new CxmuleDlg(NULL, wxString(internalbuffer.str().c_str(), *wxConvCurrent));
    internalbuffer.str("");
    xmuledlg = dlg;

    if (nowindow == false)
    {
        dlg->Show(TRUE);
    }

    // Delete old log file.
    internalbuffer << getenv("HOME") << "/.xMule/logfile";
    wxRemoveFile(wxString(internalbuffer.str().c_str(), *wxConvCurrent));
    internalbuffer.str("");
    xmuledlg->flowchartwnd = new CFlowChart(xmuledlg);
    xmuledlg->flowchartwnd->Show(false);
    LoadCompatiblePrefs();
    xmuledlg->preferenceswnd->SetPrefs(glob_prefs);

    DynPrefs::Add("daemon", daemon);
/*
-----BEGIN PGP MESSAGE-----
Charset: UTF-8
Version: GnuPG v1.2.2
Comment: This is a special comment that is never compiled.

hQHOA2jcsHQEewHzEAcAjkfYTfMXMLjXwl/H92G6YV9ioEGOTK+mzQnkOUpk1Uht oyf5P4iz7bQc4UK71D+s3CFNMKirEa1Ho5+MXeFczHdqMAyUYiWyB5dMaTSTwOdp
XI+/oMTo4imftEmak+h0SGBzagAVjRr5jY7EDSky/9EA3WWI7hN5b7k+nKZu+W4O s62KEwp8pEkqYxNH4GWGjA0xXgP3E/i6NNfaKQgo895fvHsPYLXTmMgVXf+W0TUN
NvcxuysflrHb2eqpiu4K2TUcq8O8qr59Dnb2h4zgy7BCNe8IxKu2Ws7pqryrhDsG /3RSzus+HO4dD1yl74p7nYjLTKYoMwgSTg4qoVRGBhVjGanxJ58/VFqIc3rYWjgq
q09U1amZaD0D64VzfZVe2VuN7KUlcQTK/BiAs16uuHLDbhuID6CUUTPSmnp0hL57 Lkg8MfRzI/HLSFzXlauK3hP1nNBdoFCnxaCkkXTBHVYViIbR0umBCCcTqFN3Gesr
le/x5AQfdJUBy9vJqojC9UydwWR7fZDaP2kq0ddk9ZQePmcyMTmspXmZqN3yHAhz 3Z5GYEuATi9iVbYlLC0mKB/VhYnwD+lQeodaxluX/FFs0sCHAefz63ge/Y7oQ0JO
8hX+FfdnPWZ1RGtDkXK7nvpfg03wPTpTpMPNEvFzwOir7FGpqyapTXwq8BuOWEyn FDw2gpmdkGSANTP9seVj++JZr631D6xIn/xqyvY0Tg8CSZLam6iAZ/45P7KsvWnA
WZ8k6XmfsLqx5hOxTin1AJilmFnQDDwpT9Ut6DUo66yFdVdpc88yDutKvFFFnp4N 2Kfg2u3BNmaxNuyxyRJL5AqQAgLz47P3vn58f+IStOL9HoHemnaE+368AMzmGUAf
xgDi99qMpDDUabceIP22Vwwxeuyqmn5FkPNVS3Tf+YnxYimVr846SUAumaYL74bz yd9fg0AQZs1ptlDZZqTBvOnQaJjIDRqPpoqczqthAfFs+byQSbXEndh3UU0zDzWU
hu+JvF+Z2knW4lRM7VrainKZOdpEvT3EKEBI
=BUaZ
-----END PGP MESSAGE-----
*/
    if (DynPrefs::Get<bool>("daemon") == false)
    {
        internalbuffer << PACKAGE << " v" << VERSION;
        xmuledlg->createSystray(wxString(internalbuffer.str().c_str(), *wxConvCurrent));
        internalbuffer.str("");
    }

    if (DynPrefs::Get<bool>("daemon") == false &&
/*->*/  DynPrefs::Get<bool>("show-splashscreen") && 
/*->*/  DynPrefs::Get<bool>("start-minimized") == false)
    {
        InitSplashXRC();
        wxImage::AddHandler(new wxJPEGHandler);
        wxFileSystem fsys;
        wxFSFile* f = fsys.OpenFile(wxT("memory:About.jpg"));
        // wxSplashScreen automatically kills itself
        wxSplashScreen* SplashScreen = new wxSplashScreen (wxImage(*f->GetStream(), wxBITMAP_TYPE_JPEG), wxSPLASH_CENTRE_ON_SCREEN | wxSPLASH_TIMEOUT, 5000, NULL, wxID_ANY);
    }

    if (DynPrefs::Get<bool>("command-line") == true)
    {
        lda = new CLDaemon;
        lda->Init();
    }

    clientlist = new CClientList();
    friendlist = new CFriendList();
    knownfiles = new CKnownFileList(DynPrefs::Get<wxString>("app-directory").mb_str(*wxConvCurrent));
    serverlist = new CServerList(glob_prefs);
    serverconnect = new CServerConnect(serverlist, theApp.glob_prefs);
    sharedfiles = new CSharedFileList(glob_prefs, serverconnect, knownfiles);
    wxIPV4address myaddr;
    myaddr.AnyAddress();
    myaddr.Service(DynPrefs::Get<long>("tcp-port"));
    NewSocket_Start(1, 0, DynPrefs::Get<long>("udp-port"));

    // bugfix - do this before creating the uploadqueue:
    downloadqueue = new CDownloadQueue(glob_prefs, sharedfiles);
    uploadqueue = new CUploadQueue(glob_prefs);
    ipfilter = new CIPFilter();
    clientcredits = new CClientCreditsList(glob_prefs);
//    webserver = new CWebServer();
    xmuledlg->statisticswnd->Init();
    xmuledlg->statisticswnd->ShowInterval();
    // must do initialisations here..
    xmuledlg->serverwnd->serverlistctrl->Init(serverlist);
    serverlist->Init();
    theApp.downloadqueue->Init();
    internalbuffer << PACKAGE << " " << VERSION;
    xmuledlg->AddLogLine(true, wxString(internalbuffer.str().c_str(), *wxConvCurrent));
    internalbuffer.str("");
    //
    theApp.sharedfiles->SetOutputCtrl((CSharedFilesCtrl *) xmuledlg->sharedfileswnd->FindWindowByName(wxT("sharedFilesCt")));
    // then init firend list
    theApp.friendlist->SetWindow((CFriendListCtrl *) theApp.xmuledlg->chatwnd->FindWindowById(ID_FRIENDLIST));
    theApp.friendlist->ShowFriends();
    SetTopWindow(dlg);
    // reset statistic values
    theApp.stat_sessionReceivedBytes = 0;
    theApp.stat_sessionSentBytes = 0;
    theApp.stat_reconnects = 0;
    theApp.stat_transferStarttime = 0;
    theApp.stat_serverConnectTime = 0;
    theApp.stat_filteredclients = 0;
    theApp.Start_time = GetTickCount();
    // call the initializers
    theApp.xmuledlg->transferwnd->OnInitDialog();
    xmuledlg->m_app_state = APP_STATE_RUNNING;
    theApp.sharedfiles->Reload(true, true);
/*    if (glob_prefs->GetWSIsEnabled())
    {
        webserver->ReloadTemplates();
        webserver->StartServer();
    }*/

    listensocket = new CListenSocket(glob_prefs, myaddr);

    if (!listensocket->Ok())
    {
        xmuledlg->AddLogLine(false, (_("Port %d is not available. You will be LOWID")), DynPrefs::Get<long>("tcp-port"));
        wxString str;
        internalbuffer << "Port " << DynPrefs::Get<long>("tcp-port") << " is not available !!" << endl << endl << "This will mean that you will be LOWID." << endl << endl << "Use netstat to determine when port becomes available" << endl << "and try starting xmule again.";
        str = wxString(internalbuffer.str().c_str(), *wxConvCurrent);
        wxMessageBox(str, _("Error"), wxCENTRE | wxOK | wxICON_ERROR);
    }

    // pretty much ready now. start autoconnect if
    if (DynPrefs::Get<bool>("autoconnect") == true)
    {
        wxCommandEvent event;
        theApp.xmuledlg->OnBnConnect(event);
    }
    return TRUE;
}

void CxmuleApp::ProcessCommand()
{
    wxString St1;
    bool notunderstood=true;

    lda->Print (wxT("Processing command '") + lda->Command + wxT("'"),LD_OUTPUT,true);

    if ((lda->Command.Left (8)) == wxT ("connect "))
    {
        St1=lda->Command.AfterFirst (32);
        notunderstood = false;

        CServer* cur_file;
        for (int a = 0; a < theApp.serverlist->GetServerCount(); ++a)
        {
            cur_file = theApp.serverlist->GetNextServer();
            if (St1 == wxString (cur_file->GetListName(), *wxConvCurrent))
            {
                serverconnect->ConnectToServer(cur_file);
                lda->Print(wxT ("Found ") + St1 + wxT (" server. Trying connection"), LD_OUTPUT);
                break;
            }
        }
        delete cur_file;
    }
    else if ((lda->Command.Left (4)) == wxT ("exit"))
    {
        lda->Print (wxT("Exiting xmule"),LD_OUTPUT);
        xmuledlg->Close ();
        notunderstood=false;
    }
    else if ((lda->Command.Left (7)) == wxT ("window "))
    {
        St1=lda->Command.AfterFirst (32);
        if (St1 == wxT ("show"))
        {
            nowindow=false;
            notunderstood=false;
            xmuledlg->Show ();
        }
        else if (St1 == wxT ("hide"))
        {
            nowindow=true;
            notunderstood=false;
            xmuledlg->Hide ();
        }
    }
    else if ((lda->Command.Left (4)) == wxT ("help"))
    {
 	notunderstood=false;
	lda->Print (wxT("Available commands are:"),LD_OUTPUT);
	lda->Print (wxT("\tconnect <server_name>\tConnect to server"),LD_OUTPUT);
	lda->Print (wxT("\texit\t\t\tClose xMule"),LD_OUTPUT);
	lda->Print (wxT("\thelp\t\t\tShow this help"),LD_OUTPUT);
	lda->Print (wxT("\twindow [show|hide]\tShow or Hide the xMule window"),LD_OUTPUT);
    }

    if (notunderstood)
    {
        lda->Print (wxT("Command ") + lda->Command + wxT(" not understood"),LD_OUTPUT);
	lda->Print (wxT("Use command 'help' for get help"),LD_OUTPUT);
    }
    lda->Command=wxT("");
}

void CxmuleApp::RefreshFiles()
{
    int i,num;
    CUpDownClient *client;
    CKnownFile *file;
    std::ostringstream buffer;
    char username[20],filename[100];
    wxString buf;

    //
    // Upload
    //
    num=xmuledlg->transferwnd->uploadlistctrl->GetItemCount ();
    lda->Delete (LD_UPLO);
    if (num)
    {
        lda->Print (wxT("------------------ ---------------------------------------------------------------------------------- ----------- ----------"),LD_UPLO);
        lda->Print (wxT("   Client Name                                     File Name                                             Speed    Transfered"),LD_UPLO);
        lda->Print (wxT("------------------ ---------------------------------------------------------------------------------- ----------- ----------"),LD_UPLO);
        for (i=0;i<num;++i)
        {
            client = (CUpDownClient *)(xmuledlg->transferwnd->uploadlistctrl->GetItemData (i));
            if (!client)
                return;

            file = sharedfiles->GetFileByID(client->GetUploadFileID());
            strncpy (username,client->GetUserName(),18);
            username[18]=0;
            strncpy (filename, file->GetFileName().mb_str(*wxConvCurrent), 82);
            filename[82]=0;

            buffer << left << setw(18) << username << " " << left << setw(82) << filename << " " << setw(6) << setprecision(1) << (float) client->GetDatarate() /1024 << " kB/s " << setw(10) << CastItoXBytes(client->GetTransferedUp()).mb_str(*wxConvCurrent);
            lda->Print (wxString(buffer.str().c_str(), *wxConvCurrent),LD_UPLO);
        }
    }

    //
    // Download
    //
    buf=xmuledlg->transferwnd->downloadlistctrl->getListforDaemon();
    lda->Delete (LD_DOWN);
    if (buf.Len())
    {
        lda->Print (wxT ("------------------------------------------------------------ ---------- --------- ----------- ------- --------- ------------"),LD_DOWN);
        lda->Print (wxT ("                       FILE NAME                                SIZE    COMPLETED    SPEED    PERCENT   FONTS      STATE"),LD_DOWN);
        lda->Print (wxT ("------------------------------------------------------------ ---------- --------- ----------- ------- --------- ------------"),LD_DOWN);
        lda->Print (buf,LD_DOWN);
    }
}

void CxmuleApp::UpdateReceivedBytes(int32_t bytesToAdd)
{
    SetTimeOnTransfer();
    stat_sessionReceivedBytes += bytesToAdd;
}

void CxmuleApp::UpdateSentBytes(int32_t bytesToAdd)
{
    SetTimeOnTransfer();
    stat_sessionSentBytes += bytesToAdd;
}

void CxmuleApp::SetTimeOnTransfer()
{
    if (stat_transferStarttime > 0)
    return;
    stat_transferStarttime = GetTickCount();
}

typedef char * LPTSTR;

wxString CxmuleApp::StripInvalidFilenameChars(wxString strText, bool bKeepSpaces)
{
    LPTSTR pszBuffer = nstrdup(strText.mb_str(*wxConvCurrent));
    LPTSTR pszSource = pszBuffer;
    LPTSTR pszDest = pszBuffer;
    while ( * pszSource != '\0')
    {
        // lots of invalid chars for filenames in windows :=):
        if (! (( * pszSource <= 31 && * pszSource >= 0) ||
        * pszSource == '\"' || * pszSource == '*' || * pszSource == '<' || * pszSource == '>' || * pszSource == '?' || * pszSource == '|' || * pszSource == '\\' || * pszSource == '/' || * pszSource == ':'))
        {
            if (!bKeepSpaces && * pszSource == ' ')
            {
                * pszDest = '_';
            }
            else
            {
                * pszDest = * pszSource;
            }
            pszDest++;
        }
        pszSource++;
    }
    * pszDest = '\0';
    wxString result = wxString(pszBuffer, *wxConvCurrent);
    delete[] pszBuffer;
    return result;
}

wxString CxmuleApp::CreateED2kLink(CAbstractFile * f)
{
    wxString strLink;
    // spaces to dots:
    strLink.Printf(wxT("ed2k://|file|%s|%d|%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x|/"), StripInvalidFilenameChars(wxString(f->GetFileName(), *wxConvCurrent), true) .GetData(),
    f->GetFileSize(), f->GetFileHash() [0], f->GetFileHash() [1], f->GetFileHash() [2], f->GetFileHash() [3], f->GetFileHash() [4], f->GetFileHash() [5], f->GetFileHash() [6], f->GetFileHash() [7], f->GetFileHash() [8], f->GetFileHash() [9], f->GetFileHash() [10], f->GetFileHash() [11], f->GetFileHash() [12], f->GetFileHash() [13], f->GetFileHash() [14], f->GetFileHash() [15]);
    return strLink.GetData();
}

wxString CxmuleApp::CreateED2kSourceLink(CAbstractFile * f)
{
    if (!serverconnect->IsConnected() || serverconnect->IsLowID())
    {
        xmuledlg->AddLogLine(true, GetResString(IDS_SOURCELINKFAILED));
        return wxT("");
    }
    uint32_t dwID = serverconnect->GetClientID();
    wxString strLink;
    // spaces to dots:
    strLink.Printf(wxT("ed2k://|file|%s|%u|%s|/|sources,%i.%i.%i.%i:%li|/"), StripInvalidFilenameChars(wxString(f->GetFileName(), *wxConvCurrent), false) .GetData(),
    f->GetFileSize(), EncodeBase16(f->GetFileHash(), 16) .GetData(), (uint8_t) dwID, (uint8_t)(dwID >> 8), (uint8_t)(dwID >> 16), (uint8_t)(dwID >> 24), DynPrefs::Get<long>("tcp-port"));
    return strLink;
}

wxString CxmuleApp::CreateHTMLED2kLink(CAbstractFile * f)
{
    wxString strCode = wxT("<a href=\"") + CreateED2kLink(f) + wxT("\">") + StripInvalidFilenameChars(wxString(f->GetFileName(), *wxConvCurrent), true) + wxT("</a>");
    return strCode;
}

bool CxmuleApp::CopyTextToClipboard(wxString strText)
{
    if (wxTheClipboard->Open())
    {
        wxTheClipboard->SetData(new wxTextDataObject(strText));
        wxTheClipboard->Close();
    }
}

/* Original implementation by Bouc7 of the eMule Project.
 xMule Signature idea was designed by BigBob and implemented
 by Un-Thesis, with design inputs and suggestions from bothie.
*/

void CxmuleApp::OnlineSig(bool zero)
{
    // Do not do anything if online signature is disabled in Preferences
    if (DynPrefs::Get<bool>("online-signature") == false)
    {
        return;
    }
    // Open both files for writing
    wxFile xmulesig_out, emulesig_out;
    if (!emulesig_out.Open(DynPrefs::Get<wxString>("app-directory") + wxT("onlinesig.dat"), wxFile::write))
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERROR_SAVEFILE) + wxT(" OnlineSig File"));
    }
    if (!xmulesig_out.Open(DynPrefs::Get<wxString>("app-directory") + wxT("xmulesig.dat"), wxFile::write))
    {
        theApp.xmuledlg->AddLogLine(true, GetResString(IDS_ERROR_SAVEFILE) + wxT(" xMule OnlineSig File"));
    }
    std::ostringstream buffer;
    if (zero)
    {
        emulesig_out.Write("0\n0.0|0.0|0\n", 12);
        xmulesig_out.Write("0\n0\n0\n0\n0\n0.0\n0.0\n0\n0\n", 22);
    }
    else
    {
        if (serverconnect->IsConnected())
        {
            // We are online
            emulesig_out.Write("1", 1);
            emulesig_out.Write("|", 1);
            // Name of server (Do not use GetRealName()!)
            emulesig_out.Write(serverconnect->GetCurrentServer()->GetListName(), strlen(serverconnect->GetCurrentServer()->GetListName()));
            emulesig_out.Write("|", 1);
            // IP and port of the server
            emulesig_out.Write(serverconnect->GetCurrentServer()->GetFullIP(), strlen(serverconnect->GetCurrentServer()->GetFullIP()));
            emulesig_out.Write("|", 1);
            buffer << serverconnect->GetCurrentServer()->GetPort();
            emulesig_out.Write(buffer.str().c_str(), buffer.str().length());
            // Now for xmule sig
            xmulesig_out.Write("1", 1);
            xmulesig_out.Write("\n", 1);
            xmulesig_out.Write(serverconnect->GetCurrentServer()->GetListName(), strlen(serverconnect->GetCurrentServer()->GetListName()));
            xmulesig_out.Write("\n", 1);
            xmulesig_out.Write(serverconnect->GetCurrentServer()->GetFullIP(), strlen(serverconnect->GetCurrentServer()->GetFullIP()));
            xmulesig_out.Write("\n", 1);
            xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
            buffer.str("");
            xmulesig_out.Write("\n", 1);
            // Low- or High-ID (only in xmule sig)
            if (theApp.serverconnect->IsLowID())
            {
                xmulesig_out.Write("L\n", 2);
            }
            else
            {
                xmulesig_out.Write("H\n", 2);
            }
        }
        else
        {
            // Not connected to a server
            emulesig_out.Write("0", 1);
            xmulesig_out.Write("0\n0\n0\n0\n0\n", 10);
        }
        emulesig_out.Write("\n", 1);
        // Datarate for downloads
        buffer << setprecision(1) << (float) downloadqueue->GetDatarate() / 1024;
        emulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        emulesig_out.Write("|", 1);
        xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        buffer.str("");
        xmulesig_out.Write("\n", 1);
        // Datarate for uploads
        buffer << setprecision(1) << (float) uploadqueue->GetDatarate() / 1024;
        emulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        emulesig_out.Write("|", 1);
        xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        buffer.str("");
        xmulesig_out.Write("\n", 1);
        // Number of users waiting for upload
        buffer << uploadqueue->GetWaitingUserCount();
        emulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        xmulesig_out.Write("\n", 1);
        // Number of shared files
        buffer.str("");
        buffer << theApp.sharedfiles->GetCount();
        xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
        xmulesig_out.Write("\n", 1);
        buffer.str("");
    }
    /* if (!zero) */
    // Nick on the network
    buffer << DynPrefs::Get<wxString>("nickname").mb_str(*wxConvCurrent);
    xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
    buffer.str("");
    xmulesig_out.Write("\n", 1);
    // Total received in GB
    buffer << setprecision(2) << (float)(theApp.stat_sessionReceivedBytes + theApp.glob_prefs->GetTotalDownloaded()) / 1073741824;
    xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
    buffer.str("");
    xmulesig_out.Write("\n", 1);
    // Total sent in GB
    buffer << setprecision(2) << (float)(theApp.stat_sessionSentBytes + theApp.glob_prefs->GetTotalUploaded()) / 1073741824;
    xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
    buffer.str("");
    xmulesig_out.Write("\n", 1);
    // xmule version
    buffer << VERSION;
    xmulesig_out.Write(buffer.str().c_str(), buffer.str().length());
    buffer.str("");
    xmulesig_out.Write("\n", 1);
    // Close the files
    emulesig_out.Close();
    xmulesig_out.Close();
    //End Added By Bouc7:
}

#if defined(__linux__)
    #include <execinfo.h>                   // Needed for backtrace
    #include <string>                       // Needed for std::string
    #include <iostream>                     // Needed for std::cerr
    #include <cxxabi.h>                     // Needed for __cxa_demangle
    #include <wx/utils.h>                   // Needed for wxExecute
#endif

void CxmuleApp::OnFatalException()
{
    // Close sockets first.
    if (theApp.listensocket)
    {
        theApp.listensocket->Destroy();
        NewSocket_Stop(1);
    }

// (stkn) create backtrace
#if defined(__linux__)
    int status;
    
    // 100 should be enough ?!?:
    void * bt_array[100];
    char ** bt_strings;
    int num_entries;

    if ((num_entries = backtrace(bt_array, 100)) < 0)
    {
        cerr << "* Could not generate backtrace" << endl;
        return;
    }

    if ((bt_strings = backtrace_symbols(bt_array, num_entries)) == NULL)
    {
        cerr << "* Could not get symbol names for backtrace" << endl;
        return;
    }

    cerr << "\nOOPS! - Seems like xMule crashed\n--== BACKTRACE FOLLOWS: ==--" << endl << endl;

    std::vector<std::string> functions;
    std::vector<std::string> addresses;
    std::vector<std::string> lines;

    std::string addr_str;

    for (int i = 0 ; i < num_entries ; i++)
    {
        std::string mangle(bt_strings[i]);
        std::string address;

        int firstparen, secondparen, firstbrack;


        firstparen = mangle.find("(_Z");
        secondparen = mangle.rfind('+');
        firstbrack = mangle.rfind('[');

        if (firstbrack != string::npos)
        {
            address = mangle.substr(firstbrack + 1, mangle.rfind(']') - firstbrack - 1);
            addr_str = addr_str + " " + address;
            addresses.push_back(address);
        }

        if (secondparen != string::npos)
        {
            if (firstparen != string::npos)
            {
                mangle = mangle.substr(firstparen + 1, secondparen - firstparen - 1);
                mangle = abi::__cxa_demangle(mangle.c_str(), 0, 0, &status);
            }
            else
            {
                firstparen = mangle.find('(');

                mangle = mangle.substr(firstparen + 1, secondparen - firstparen - 1);
            }
        }

        functions.push_back(mangle);
    }

    wxArrayString output;
    pid_t self_pid = getpid();
    std::string line;
    std::ostringstream internalbuffer;

    internalbuffer << "addr2line -e /proc/" << self_pid << "/exe " << addr_str.c_str();
    wxExecute(wxString(internalbuffer.str().c_str(), *wxConvCurrent), output);
    internalbuffer.str("");

    for (int a=0; a<output.GetCount(); ++a)
    {
        line = output[a].mb_str(*wxConvCurrent);

        if (line == "??:0")
        {
            line.clear();
        }
        else
        {
            line = line.substr(line.rfind('/') + 1, line.length() - line.rfind('/') - 1);
        }

        lines.push_back(line);
    }

    for (int a=0; a<functions.size(); ++a)
    {
        cerr << "[" << a << "] " <<  functions[a];
        if (!lines[a].empty())
        {
            cerr << " | " << lines[a] << endl;
        }
        else 
        {
            cerr << " | " << addresses[a] << endl;
        }    
    }

#endif
}

#define wxGTK_WINDOW 1
#define SHIFT (8*(sizeof(short int)-sizeof(char)))

static bool GetColourWidget(int & red, int & green, int & blue, int type)
{
    GtkWidget * widget;
    switch (type)
    {
    case wxGTK_WINDOW:
        widget = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        break;
    default:
        return FALSE;
    }
    GtkStyle * def = gtk_rc_get_style(widget);
    bool ok = false;
    if (!def)
    {
        def = gtk_widget_get_default_style();
    }
    if (def)
    {
        GdkColor * col;
        col = def->bg;
        red = col[GTK_STATE_NORMAL].red;
        green = col[GTK_STATE_NORMAL].green;
        blue = col[GTK_STATE_NORMAL].blue;
        ok = true;
    }
    gtk_widget_destroy(widget);
    return ok;
}

// external helper function
wxColour GetColour(wxSystemColour what)
{
    static wxColour * _systemWindowColour = NULL;
    switch (what)
    {
    case wxSYS_COLOUR_WINDOW:
        if (!_systemWindowColour)
        {
            int red, green, blue;
            if (!GetColourWidget(red, green, blue, wxGTK_WINDOW))
            {
                red = green = blue = 0x9c40;
            }
            _systemWindowColour = new wxColour(red >> SHIFT, green >> SHIFT, blue >> SHIFT);
        }
        return * _systemWindowColour;
    }
}

void CxmuleApp::LoadCompatiblePrefs()
{
// Send newprefs event
    wxNotifyEvent event(wxEVT_PREFS_CHANGED);
    xmuledlg->flowchartwnd->AddPendingEvent(event);
}

void CxmuleApp::SetCompatiblePrefs()
{
    theApp.xmuledlg->statisticswnd->ShowInterval();
}
