// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef _XMULE_H_
#define _XMULE_H_

#include "wintypes.h"                  // x::DWORD - audited 4 Nov 2004

#include <stdint.h>                    // uint32_t
#include <wx/app.h>                    // wxApp
#include <wx/intl.h>                   // wxLocale
#include <wx/settings.h>               // wxSystemColour

class CAbstractFile;
class CClientCreditsList;
class CClientList;
class CClientUDPSocket;
class CDownloadQueue;
class CFriendList;
class CIPFilter;
class CKnownFileList;
class CLDaemon;
class CListenSocket;
class CPreferences;
class CServerConnect;
class CServerList;
class CSharedFileList;
class CUploadQueue;
class CxmuleDlg;

class DynamicPreferences;

#define theApp (*((CxmuleApp*)wxTheApp))
#define G_BLEND(a,b) ( ((int)a*b)/100>255?255:((int)a*b)/100 )

class CxmuleApp: public wxApp
{
public:
    CxmuleApp();
    virtual ~CxmuleApp();

    virtual bool OnInit();
    int OnExit();
    void OnFatalException();

    CxmuleDlg* xmuledlg;
    CClientList* clientlist;
    CKnownFileList* knownfiles;
    CPreferences* glob_prefs;
    CServerConnect* serverconnect;
    CServerList* serverlist;
    CSharedFileList* sharedfiles;
    CListenSocket* listensocket;
    CUploadQueue* uploadqueue;
    CDownloadQueue* downloadqueue;
    CClientCreditsList* clientcredits;
    CFriendList* friendlist;
    wxString* pendinglink;
    CIPFilter* ipfilter;
    uint64_t stat_sessionReceivedBytes;
    uint64_t stat_sessionSentBytes;
    uint16_t stat_reconnects;
    x::DWORD stat_transferStarttime;
    x::DWORD stat_serverConnectTime;
    uint16_t stat_filteredclients;
    x::DWORD Start_time;
    bool daemon, nowindow;
    CLDaemon* lda;

    // Implementierung
    // ed2k link functions
    wxString StripInvalidFilenameChars(wxString strText, bool bKeepSpaces = true);
    wxString CreateED2kLink(CAbstractFile *f);
    wxString CreateHTMLED2kLink(CAbstractFile *f);
    wxString CreateED2kSourceLink(CAbstractFile *f);
    bool CopyTextToClipboard(wxString strText);
    void OnlineSig(bool zero = false);
    void UpdateReceivedBytes(int32_t bytesToAdd);
    void UpdateSentBytes(int32_t bytesToAdd);
    void ProcessCommand ();
    void RefreshFiles ();

protected:
    bool ProcessCommandline();
    void SetTimeOnTransfer();
    wxLocale m_locale;

public:
    void LoadCompatiblePrefs();
    void SetCompatiblePrefs();
};

DECLARE_APP(CxmuleApp)

// helper
wxColour GetColour(wxSystemColour what);

#endif // _XMULE_H_
