// The xMule Project - A Peer-2-Peer File Sharing Program
//
// Copyright (C) 2003-2006 Theodore R. Smith ( hopeseekr@gmail.com / http://www.xmule.ws/ )
// Copyright (C) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of Version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

#ifndef XMULEIPV4ADDRESS_H
#define XMULEIPV4ADDRESS_H

#if defined(__WXMSW__)
    #include <winsock.h>
#else
    #include <sys/socket.h>
    #include <netinet/in.h>
    #include <arpa/inet.h>
#endif

#include <wx/defs.h>                   // wxWidgets definitions
#include <wx/object.h>                 // Needed by wx/sckaddr.h
#include <wx/sckaddr.h>                // wxIPV4address

class xmuleIPV4Address: public wxIPV4address
{
public:
    xmuleIPV4Address() { }
    virtual bool Hostname(unsigned long addr)
    {
        return (GAddress_INET_SetHostAddress(m_address, addr) == GSOCK_NOERROR);
    }

    virtual bool Hostname(const wxString& addr)
    {
        if (addr.empty())
        {
            return false;
        }

        struct in_addr inaddr;
        inet_aton(static_cast<const char *>(addr.mb_str()), &inaddr);

        #if wxCHECK_VERSION(2, 5, 2)
            inaddr.s_addr = ntohl(inaddr.s_addr);
        #endif
        return (GAddress_INET_SetHostAddress(m_address, inaddr.s_addr) == GSOCK_NOERROR);
    }
};

#endif // XMULEIPV4ADDRESS_H
