unit UntMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls,FileCtrl, ImgList;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    Label2: TLabel;
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    Btn_BackUp: TBitBtn;
    Btn_Cancel: TBitBtn;
    SBar: TStatusBar;
    Btn_LoadURL: TButton;
    Label3: TLabel;
    EdtFavPath: TEdit;
    ImageList1: TImageList;
    procedure Btn_CancelClick(Sender: TObject);
    procedure Btn_LoadURLClick(Sender: TObject);
    procedure Btn_BackUpClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListView1CustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  FavoritesPath:string;

implementation
  uses untLoadFav,untFileInfo,untBackUp;
{$R *.dfm}

procedure TForm1.Btn_CancelClick(Sender: TObject);
begin
  close;
end;

//URLļ
procedure TForm1.Btn_LoadURLClick(Sender: TObject);
  var i:integer;
      StrLst:TStringList;
      FileName:String;
      LstItem:TListItem;
begin
  listview1.Clear;
  StrLst:=TStringList.Create;
  LoadFile(EdtFavPath.Text,StrLst);
  for i:=0 to StrLst.Count -1 do
    begin
      application.ProcessMessages;
      FileName:=StrLst.Strings[i];
      LstItem:=listview1.Items.Add;
      LstItem.Caption:=LoadURLName(FileName);//ļ
      LstItem.SubItems.Add(LoadURL(FileName));//ļָURL
      LstItem.SubItems.Add(FileName); //ļλ
      LstItem.SubItems.Add(PathName(EdtFavPath.Text, FileName)); //ļڲλ
      SBar.Panels[0].Text:=':'+LoadURLName(FileName);
    end;
  SBar.Panels[0].Text:='IEղؼܹ'+
                       Inttostr(Listview1.Items.Count)+'Internetݷʽ.';
end;

//URLļ
procedure TForm1.Btn_BackUpClick(Sender: TObject);
  var i:integer;
begin
  if (listview1.Items.Count>0) and (edit1.Text<>'') then
    begin
      Btn_BackUp.Enabled :=false;
      Btn_Cancel.Enabled :=false;
      Btn_LoadURL.Enabled :=false;
      for i:=0 to listview1.Items.Count -1 do
        begin
          application.ProcessMessages;
          //Զ屸ݺBackUp
          BackUpFile(EdtFavPath.Text,Edit1.Text,listview1.Items.Item[i].SubItems.Strings[2]);
          Sbar.Panels[0].Text :='ڱݣ...'+
                            listview1.Items.Item[i].SubItems.Strings[2];
        end;
      Btn_BackUp.Enabled :=true;
      Btn_Cancel.Enabled :=true;
      Btn_LoadURL.Enabled :=true;
      Sbar.Panels[0].Text :='.';
      messagebox(handle,'ϣ  ','ʾ',0+64);
    end
  else if listview1.Items.Count=0 then
    messagebox(handle,'ļб棡 ','ʾ',0+32)
  else if edit1.Text='' then
    messagebox(handle,'뱣· ','ʾ',0+32);
end;

//ѡ񱸷·
procedure TForm1.BitBtn1Click(Sender: TObject);
   var Dir:string;
begin
   if SelectDirectory('Select a directory','',Dir) then
      Edit1.Text:=Dir;
   form1.SetFocus;
end;

procedure TForm1.FormCreate(Sender: TObject);
  var Key:string;
begin
  Key:='\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders';
  //LoadStringעлȡIEղؼ·
  FavoritesPath:=LoadString(HKEY_CURRENT_USER,Key,'Favorites','');
  EdtFavPath.Text :=FavoritesPath;
  //URL¼
  Btn_LoadURLClick(nil);
  edit1.Text:=extractFilepath(application.ExeName)+'BackUp\';

end;

procedure TForm1.ListView1CustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  //ListViewʾ
  if odd(item.Index) then
    item.ListView.Canvas.Brush.Color:=$00FEF4E7
  else
    item.ListView.Canvas.Brush.Color:=$00F7F8F9;
end;

end.
