## 介绍 {docsify-ignore}

袋鼠存储，是一款跨平台，跨网络管理数据，就近为用户提供服务的分布式服务。

虽然现下，已经存在众多的网盘可供用户作为选择使用。袋鼠存储的推出主要是为用户提供一种新的存储方案，以解决下面提到的一些棘手问题：

**如何应对网盘提供商关停服务导致不可用问题**

如果这个问题没有出现过，可能用户也就没那么在意！但是，纵观网盘的发展史

- 2005年，Gmail的大容量空间已被用户用来储存文件，此时网盘的概念渐渐普及。
- 2009年，115网盘，华为DBank......等成为国内网盘的代表之一。
- 2012年，各家网盘纷纷崛起，网盘已经进入3.0时代，个人云存储占据绝对主角。
- ...
- 2016年，各家网盘纷纷关闭，如今只剩下为数不多的几家。

相信很多网友，与我们一样，作为使用者亲身体会过这个历程，也深知其中的无奈与痛苦！因此，袋鼠存储在诞生之初，首要考虑的就是如何解决该问题。

袋鼠存储的解决方案中对下面三点提供了重要支持，以求真正地解决这个问题

1. [支持用户自由部署](/usage_server)
2. [支持独立组网](/admin_self_network)
3. [数据存储在本地](/store_strage)

用户在自己的设备中部署了 `kstore` 服务，启用独立子网后，由于数据本身存储在本地，因此在后续的使用过程中，用户数据就不会跟官方子网有任何关系。若需要跨网络在多个设备中进行同步，自行在公网云主机上部署一个节点作为中继传输服务，这样该子网中的通讯和文件中继传输都不会经过我们的服务器。如下图所示：

![](docimgs/networks.png)

?> *可通过[网络通讯](/networks.md)，[独立组网](/admin_self_network)，[存储策略](/store_strage)了解更多细节*

即使由于各种原因，导致我们停止研发，关停官网服务，影响到的也只是不再发布新版本及官网子网不可用。但对于用户自行组建的独立子网则完全没有影响，特别是用户最珍贵的数据，一直都掌握在用户手中！:fist:

**如何最大程度地尊重用户个人隐私**

伴随着互联网的发展，大家也越来越多地关注个人隐私问题。在使用个人云存储的网盘方案中，用户必须将数据全盘托管于服务提供商，这就不可避免地存在个人数据的隐私问题：可能会被分析，篡改，甚至被恶意删除。当然，出现这些问题的只是个别网盘，大部分网盘提供商还是在努力维护用户个人隐私的。

!> 袋鼠存储最基础功能便是存储用户数据，我们立下宗旨：**绝不染指用户数据！**

这是我们为了最大程度地尊重用户个人隐私做出的承诺，因此在我们的实现方案中，做出了如下选择：

1. 将用户数据存储在本地，即部署 `kstore` 服务的设备
2. 使用官方子网进行中继传输时，不会对用户数据做任何备份
3. 独立组网场景下，用户数据与官方之间不存在任何关系
4. 禁用了官网访问的所有入口，拒绝官网存储用户数据

?> 文件传输时使用了加密验证连接以及二进制加密传输，以确保传输过程的数据安全

用户数据不仅涉及到个人隐私，数据还是财富，更应该藏富于民。

**如何更好地降低存储成本**

在各家网盘纷纷关闭后，存活下来的，现在大部分必须开通会员或超级会员才能正常使用，否则上传、下载、分享、存储......等功能估计会让你怀疑人生。这些主要还是网盘各方面的高成本所致。

在袋鼠存储的解决方案中，我们提倡用户自行部署服务，主要基于以下几方面的考量：

- 部署设备，树莓派，mini主机或者普通的PC电脑都是可以直接部署，对个体用户来说，这个成本完全可以接受。对企业而言，还可以选择性能更好的服务器或局域网的工作站主机。
- 存储介质，用户可以添购多个硬盘进行[自主扩容](/admin_expansion)，甚至用户可以组成存储阵列后再接入(另外我们也提供了[同步/备份](/admin_sync_backup)功能)，实现一次性购买，一直使用。
- 传输速率，在传输文件时，kstore 提供了中继和 P2P 两种并发传输方式，用户也可自行部署中继服务以提高传输速率。另外，随着更好的网络基础设施的建设，5G时代的到来是大势所趋，相信不久大家就能使用上低延时，高速率的5G网络。这为部署在不同局域网环境中的设备之间的通讯和同步提供了越来越好的用户体验。

现在，我们向合作伙伴提供的都是一体机存储方案，机子插电源接路由器就可用。有需要的朋友也可以邮件我们(roostorebiz@163.com)详细咨询

**小结**

袋鼠存储致力于为用户提供一种新的存储解决方案，使得用户对服务可控，对数据可控还有对成本可控！