## 说明
kstore 支持在 linux 环境以 docker 容器的形式运行服务端

# 运行
通过 docker, 可以直接一步到位安装运行 docker 容器下的 kstore 服务:
```
使用 Host 上 /etc/kstore 目录下的配置文件运行 amd64 位的 kstore, 并将数据存储在 Host 的 /var/kstore 目录:
docker run -d --name=kstore --net=host --restart=always -v /var/kstore:/opt/kstore/var -v /etc/kstore:/opt/kstore/conf -t roostore/kstore
```

上面这条命令会自动联网下载最新版本的 kstore docker 镜像, 下载完成后自动运行.

注意:
- 上面的命令是在 amd64 位的 linux 操作系统上执行的
- 启动的容器名为 kstore
- 出错或开机后会自动重启 kstore 服务
- 用户产生的数据保存在 Host 的 /var/kstore 下
- 使用 Host 上的 /etc/kstore 目录下的配置(默认为空, 如需配置, 参考[配置](/configs))

!> 若不挂载目录使用，删除容器会删除所有数据


各版本镜像:
- amd64: roostore/kstore
- arm32: roostore/kstore-arm
- arm64: roostore/kstore-arm64

假如需要在 arm64 的开发板上运行 docker 版本 的 kstore(用户数据保存在 Host 的 /var/kstore, 配置在 Host 的 /etc/kstore):
```
docker run -d --name=kstore --net=host --restart=always -v /var/kstore:/opt/kstore/var -v /etc/kstore:/opt/kstore/conf -t roostore/kstore-arm64
```

## 访问服务
安装完 kstore 服务端之后, 用户可以在浏览器上访问 `<IP>:12048` 来打开服务端的 web 界面(IP 为服务 linux 服务器的 IP).

例如服务器 IP 为 192.168.0.100, 则可以在浏览器访问 192.168.0.100:12048.

默认地，kstore 在 `:12048` 端口提供服务。如需要切换到其他端口，参考[配置](/configs)中的说明，修改 `HTTPPort` 配置项

另外，也支持 IPv6 的形式进行访问。例如，查询到部署设备的 IPv6 地址为 `fe80::fa8b:1f4e:3d6a:a04e`，那么在浏览器中就可以通过 [http://[fe80::fa8b:1f4e:3d6a:a04e]:12048/](http://[fe80::fa8b:1f4e:3d6a:a04e]:12048/) 访问

![](docimgs/login.png)

## 修改配置
按照上面的命令, 使用的是 Host 上 /etc/kstore　目录下的配置文件，如需[修改配置](/configs)，可以先修改该目录下的配置文件，然后重启 kstore 容器即可:
```
docker restart kstore
```

## 数据存储
根据运行小节中的命令(-v /var/kstore:/opt/kstore/var), 用户产生的数据会保存到 Host 的 /var/kstore 目录下, 包括日志文件在这里

### 多硬盘
若有多个硬盘，可以同时挂载多个目录，即可重复配置 `-v <host_dir>:<container_dir>`，运行后用浏览器连接服务, 打开 kstore 的 web 页面, 参考 [自主扩容](/admin_expansion)选择这些挂载的目录


## 更新

要更新 docker 版本的 kstore:

删除当前正在运行的容器, 再重新运行即可(注意确保之前运行 kstore 的时候有将 kstore 的数据挂载到 Host 上, 避免造成数据丢失)
```
docker rm -f kstore
docker run -d --name=kstore --net=host --restart=always -v /var/kstore:/opt/kstore/var -v /etc/kstore:/opt/kstore/conf -t roostore/kstore
```
!> 非 amd64 平台, 注意将 -t 后的镜像替换为对应平台的镜像名